/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.role.confluence;

import com.atlassian.upm.license.role.confluence.ConfluenceRoleBasedLicenseManager;
import com.atlassian.upm.license.role.spi.AbstractLicensingRole;
import com.atlassian.user.Group;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;

public class ConfluenceLicensingRole
extends AbstractLicensingRole {
    private static final String MANAGEMENT_PAGE_URL = "/admin/users/domembersofgroupsearch.action";
    private final ConfluenceRoleBasedLicenseManager manager;
    private final Group group;

    public ConfluenceLicensingRole(ConfluenceRoleBasedLicenseManager manager, Group group, String key) {
        super(key, null, null);
        this.manager = (ConfluenceRoleBasedLicenseManager)Preconditions.checkNotNull((Object)manager, (Object)"manager");
        this.group = (Group)Preconditions.checkNotNull((Object)group, (Object)"group");
    }

    public URI getManagementPage() {
        try {
            return URI.create("/admin/users/domembersofgroupsearch.action?membersOfGroupTerm=" + URLEncoder.encode(this.getKey(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return URI.create(MANAGEMENT_PAGE_URL);
        }
    }

    public boolean isUserInRole(String userKey) {
        return this.manager.hasMembership(this.group, userKey);
    }

    public int getRoleCount() {
        return this.manager.getMembershipCount(this.group.getName());
    }
}

