package com.atlassian.upm.license.storage.lib;

/**
 * This exception denotes that your plugin attempted to use the 
 * Plugin License Storage plugin but could not find it available.
 * This will happen if the Plugin License Storage plugin is disabled or not installed.
 * 
 * Note that this exception will also be thrown while in UPM's Safe Mode if
 * an administrator re-enables your plugin without re-enabling the Plugin License Storage plugin.
 * 
 * This exception will NEVER be thrown when UPM is licensing-aware (UPM 2.0+)
 * because the Plugin License Storage plugin is not used from that point onward.
 */
public class PluginLicenseStoragePluginUnresolvedException extends Exception
{
    public PluginLicenseStoragePluginUnresolvedException()
    {
        super();
    }

    public PluginLicenseStoragePluginUnresolvedException(Throwable throwable)
    {
        super(throwable);
    }
}
