package com.atlassian.marketplace.client.model;

import com.atlassian.upm.api.util.Option;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;
import static com.atlassian.upm.api.util.Option.option;

/**
 * Information about a vendor on the Atlassian Marketplace site.
 */
public class Vendor
{
    @JsonProperty private final Links links;
    @JsonProperty private final long id;
    @JsonProperty private final String name;
    @JsonProperty private final String email;
    @JsonProperty private final String phone;
    @JsonProperty private final String otherContactDetails;

    // fields omitted:  address, supportOrg
    
    @JsonCreator
    Vendor(@JsonProperty("links") Links links,
           @JsonProperty("id") Long id,
           @JsonProperty("name") String name,
           @JsonProperty("email") String email,
           @JsonProperty("phone") String phone,
           @JsonProperty("otherContactDetails") String otherContactDetails)
    {
        this.links = requireProperty(links, "links");
        this.id = requireProperty(id, "id");
        this.name = requireProperty(name, "name");
        this.email = email; // optional
        this.phone = phone; // optional
        this.otherContactDetails = otherContactDetails; // optional
    }

    public Links getLinks()
    {
        return links;
    }

    /**
     * A unique identifier for the vendor.
     */
    public long getId()
    {
        return id;
    }

    /**
     * The vendor name.
     */
    public String getName()
    {
        return name;
    }

    /**
     * The vendor's primary contact email.
     */
    public Option<String> getEmail()
    {
        return option(email);
    }

    /**
     * The phone number, if any.
     */
    public Option<String> getPhone()
    {
        return option(phone);
    }

    /**
     * Optional contact information.
     */
    public Option<String> getOtherContactDetails()
    {
        return option(otherContactDetails);
    }
}
