package com.atlassian.marketplace.client.model;

import com.atlassian.upm.api.util.Option;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;
import static com.atlassian.upm.api.util.Option.option;

/**
 * A screenshot image associated with a plugin.
 */
public class Screenshot
{
    @JsonProperty private final String name;
    @JsonProperty private final Image image;
    @JsonProperty private final Image carouselImage;
    
    @JsonCreator
    Screenshot(@JsonProperty("name") String name,
               @JsonProperty("image") Image image,
               @JsonProperty("carouselImage") Image carouselImage)
    {
        this.name = requireProperty(name, "name");
        this.image = requireProperty(image, "image");
        this.carouselImage = carouselImage;  // optional
    }
    
    /**
     * The caption for the screenshot.
     */
    public String getName()
    {
        return name;
    }
    
    /**
     * The full image.
     */
    public Image getImage()
    {
        return image;
    }

    /**
     * An optional smaller version of the image to display in a carousel.
     */
    @JsonIgnore
    public Option<Image> getCarouselImage()
    {
        return option(carouselImage);
    }
}
