package com.atlassian.marketplace.client.model;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;

/**
 * A summary of user reviews for a plugin.
 */
public class ReviewSummary
{
    @JsonProperty private final Links links;
    @JsonProperty private final float averageStars;
    @JsonProperty private final int count;
    
    @JsonCreator
    ReviewSummary(@JsonProperty("links") Links links,
                  @JsonProperty("averageStars") Float averageStars,
                  @JsonProperty("count") Integer count)
    {
        this.links = requireProperty(links, "links");
        this.averageStars = requireProperty(averageStars, "averageStars");
        this.count = requireProperty(count, "count");
    }

    public Links getLinks()
    {
        return links;
    }

    /**
     * The average number of stars across all reviews of the plugin.
     */
    public float getAverageStars()
    {
        return averageStars;
    }

    /**
     * The number of reviews.
     */
    public int getCount()
    {
        return count;
    }    
}
