package com.atlassian.marketplace.client.model;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;

/**
 * A vendor's response to a user review.
 */
public class ReviewResponse
{
    @JsonProperty private final Links links;
    @JsonProperty private final String response;
    
    // fields omitted:  isPublic
    
    @JsonCreator
    ReviewResponse(@JsonProperty("links") Links links,
                   @JsonProperty("response") String response)
    {
        this.links = requireProperty(links, "links");
        this.response = requireProperty(response, "response");
    }

    public Links getLinks()
    {
        return links;
    }

    /**
     * The text of the response.
     */
    public String getResponse()
    {
        return response;
    }    
}
