package com.atlassian.marketplace.client.impl.representations;

import com.atlassian.marketplace.client.model.Links;

import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;

/**
 * Entity returned by the MPAC root resource, containing only a links map.
 */
public final class RootRepresentation
{
    @JsonProperty
    private final Links links;
    
    public RootRepresentation(@JsonProperty("links") Links links)
    {
        this.links = requireProperty(links, "links");
    }
    
    public Links getLinks()
    {
        return links;
    }
}
