package com.atlassian.marketplace.client.impl.representations;

import java.util.Collection;

import com.atlassian.marketplace.client.model.Banner;
import com.atlassian.marketplace.client.model.Links;

import com.google.common.collect.ImmutableList;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

import static com.atlassian.marketplace.client.util.ModelUtil.requireList;
import static com.atlassian.marketplace.client.util.ModelUtil.requireProperty;

/**
 * Entity returned by the /plugins/banners resource.
 */
public final class PluginBannersRepresentation
{
    @JsonProperty private final Links links;
    @JsonProperty private final int count;
    @JsonProperty private final Collection<Banner> banners;

    @JsonCreator
    public PluginBannersRepresentation(@JsonProperty("links") Links links,
                                       @JsonProperty("banners") Collection<Banner> banners,
                                       @JsonProperty("count") Integer count)
    {
        this.links = requireProperty(links, "links");
        this.banners = requireList(banners, "banners");
        this.count = requireProperty(count, "count");
    }
    
    public Links getLinks()
    {
        return links;
    }
    
    @JsonIgnore
    public Iterable<Banner> getBanners()
    {
        return ImmutableList.copyOf(banners);
    }
    
    public int getCount()
    {
        return count;
    }
}
