package com.atlassian.marketplace.client.impl;

import java.net.URI;
import java.util.Collection;

import com.atlassian.marketplace.client.MpacException;
import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.Categories;
import com.atlassian.marketplace.client.impl.representations.PluginCategoriesByAppRepresentation;
import com.atlassian.marketplace.client.impl.representations.RootRepresentation;
import com.atlassian.marketplace.client.model.PluginCategory;
import com.atlassian.marketplace.client.util.UriBuilder;

import com.google.common.collect.ImmutableList;

import static com.atlassian.marketplace.client.impl.representations.RepresentationLinks.CATEGORIES_REL;

final class CategoriesImpl implements Categories
{
    private final DefaultMarketplaceClient client;
    private final RootRepresentation root;

    CategoriesImpl(DefaultMarketplaceClient client, RootRepresentation root)
    {
        this.client = client;
        this.root = root;
    }

    @Override
    @SuppressWarnings("unchecked")
    public Iterable<String> findAll() throws MpacException
    {
        return ImmutableList.copyOf(client.getEntity(categoriesBaseUri().build(), Collection.class));
    }

    public Iterable<PluginCategory> findForApplication(ApplicationKey appKey) throws MpacException
    {
        // Should use links & URI templates when available (UPM-2465) - but currently /categories is not
        // a real resource with a links map, just a collection of strings.
        URI uri = categoriesBaseUri().path("app").path(client.urlEncode(appKey.getKey())).build();
        return client.getEntity(uri, PluginCategoriesByAppRepresentation.class).getCategories();
    }

    private UriBuilder categoriesBaseUri() throws MpacException
    {
        return UriBuilder.fromUri(client.requireLinkUri(root.getLinks(), CATEGORIES_REL, root.getClass()));
    }
}
