package com.atlassian.marketplace.client.api;

import com.atlassian.upm.api.util.Option;

import static com.atlassian.upm.api.util.Option.none;
import static com.atlassian.upm.api.util.Option.some;

/**
 * Specifies what kind of pricing information to include in query results.
 */
public final class PricingQuery
{
    private final Option<String> licenseType;
    
    private PricingQuery(Option<String> licenseType)
    {
        this.licenseType = licenseType;
    }
    
    public Option<String> getLicenseType()
    {
        return licenseType;
    }
    
    @Override
    public String toString()
    {
        return licenseType.getOrElse("all");
    }
    
    @Override
    public boolean equals(Object other)
    {
        return (other instanceof PricingQuery) ? toString().equals(other.toString()) : false;
    }
    
    @Override
    public int hashCode()
    {
        return toString().hashCode();
    }
    
    /**
     * Queries pricing for all license types (Commercial, Academic, etc.).  Use this option
     * with caution, since it can greatly increase the response size and processing time.
     */
    public static PricingQuery allPricing()
    {
        return new PricingQuery(none(String.class));
    }
    
    /**
     * Queries pricing for the specified license type.
     * @param licenseType  name of an Atlassian license type ("Commercial", "Academic", etc.).
     */
    public static PricingQuery pricingForLicenseType(String licenseType)
    {
        return new PricingQuery(some(licenseType));
    }
}
