package com.atlassian.upgrade.spi;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.upgrade.api.UpgradeContext;

/**
 * SPI for plugins and host application to implement for each Upgrade Task they wish to define. Each of these Upgrade
 * Tasks within the plugin or host application should have a unique build number and should be numerically orderable
 * by the build number. Each upgrade task also defines a downgrade task to undo the upgrade operations.
 *
 * @since v1.0
 */
@PublicSpi
public interface UpgradeTask {
    /**
     * The build number which uniquely identifies the upgrade task. When the upgrades are run each upgrade task is run
     * in order of their build number and only UpgradeTasks with values larger than the current build number are run.
     * <p>
     * When the upgrade task is completed the current build number for the plugin or host application is set to this
     * value. When the downgrade is completed the current build number for the plugin or host application is set to the
     * build number preceding this one.
     *
     * @return the build number uniquely identifying this upgrade task.
     */
    int getBuildNumber();

    /**
     * Description used to give an overview for this task to be used by support or other debugging needs.
     *
     * @return a short description for this upgrade task.
     */
    String getShortDescription();

    /**
     * Complete the UpgradeTask. If any exception is thrown during the upgrade then sub-sequent upgrades won't run and
     * this upgrade task will be re-tried next time.
     *
     * @param upgradeContext includes information about the current upgrade
     */
    void runUpgrade(UpgradeContext upgradeContext);
}
