package com.atlassian.theme.api;

import javax.annotation.Nonnull;

/**
 * Represents a color theme, does not include other concerns, e.g. typography, spacing,
 */
public interface Theme {
    @Nonnull
    ThemeColorMode getColorMode();

    /**
     * Unique across all themes as a way to identify
     */
    @Nonnull
    String getThemeKey();

    /**
     * The I18n key for the name of the theme
     */
    @Nonnull
    String getThemeI18nNameKey();
}
