/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.templaterenderer.plugins;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.remotable.api.annotation.ComponentImport;
import com.atlassian.plugin.remotable.api.annotation.PublicComponent;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.templaterenderer.TemplateContextFactory;
import com.atlassian.templaterenderer.plugins.TemplateContextItemModuleDescriptor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
@PublicComponent(value={TemplateContextFactory.class})
public class TemplateContextFactoryImpl
implements TemplateContextFactory {
    private static final Logger log = LoggerFactory.getLogger(TemplateContextFactoryImpl.class);
    private final PluginModuleTracker<Object, TemplateContextItemModuleDescriptor> templateContextItemTracker;

    @Inject
    public TemplateContextFactoryImpl(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginEventManager eventManager) {
        this.templateContextItemTracker = new DefaultPluginModuleTracker(pluginAccessor, eventManager, TemplateContextItemModuleDescriptor.class);
    }

    @Override
    public Map<String, Object> createContext(String pluginKey, Map<String, Object> contextParams) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("context", context);
        for (TemplateContextItemModuleDescriptor desc : this.templateContextItemTracker.getModuleDescriptors()) {
            if (!desc.isGlobal() && !desc.getPluginKey().equals(pluginKey)) continue;
            try {
                context.put(desc.getContextKey(), desc.getModule());
            }
            catch (RuntimeException re) {
                log.error("Error loading module for " + desc.getPluginKey() + ":" + desc.getKey(), (Throwable)re);
            }
        }
        context.putAll(contextParams);
        return context;
    }

    @PreDestroy
    public void destroy() {
        this.templateContextItemTracker.close();
    }
}

