/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.database.console;

import com.atlassian.sal.api.rdbms.TransactionalExecutor;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.h2.server.web.HackedWebServer;
import org.h2.server.web.WebServlet;
import org.h2.util.New;

public class HackedWebServlet
extends WebServlet {
    private final TransactionalExecutorFactory transactionalExecutorFactory;
    private final UserManager userManager;
    HackedWebServer hackedWebServer;
    Connection connection;

    @Inject
    public HackedWebServlet(TransactionalExecutorFactory transactionalExecutorFactory, UserManager userManager) {
        this.transactionalExecutorFactory = transactionalExecutorFactory;
        this.userManager = userManager;
    }

    public void init() {
        TransactionalExecutor executor = this.transactionalExecutorFactory.createExecutor();
        executor.readWrite().newTransaction().execute(jdbc -> {
            this.connection = jdbc;
            ServletConfig config = this.getServletConfig();
            Enumeration en = config.getInitParameterNames();
            ArrayList list = New.arrayList();
            while (en.hasMoreElements()) {
                String name = en.nextElement().toString();
                String value = config.getInitParameter(name);
                if (!name.startsWith("-")) {
                    name = "-" + name;
                }
                list.add(name);
                if (value.length() <= 0) continue;
                list.add(value);
            }
            String[] args = new String[list.size()];
            list.toArray(args);
            this.hackedWebServer = new HackedWebServer(args, this);
            HackedWebServlet.inject(((Object)((Object)this)).getClass().getSuperclass(), (Object)this, "server", (Object)this.hackedWebServer);
            return null;
        });
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        UserKey userKey = this.userManager.getRemoteUserKey(req);
        if (userKey != null && this.userManager.isSystemAdmin(userKey)) {
            TransactionalExecutor executor = this.transactionalExecutorFactory.createExecutor();
            executor.readWrite().newTransaction().execute(jdbc -> {
                this.connection = jdbc;
                final String someUrl = this.getConnectionUrl();
                HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(req){

                    public Enumeration getParameterNames() {
                        Enumeration e = super.getParameterNames();
                        Vector v = new Vector();
                        while (e.hasMoreElements()) {
                            v.add(e.nextElement());
                        }
                        v.add("jsessionid");
                        return v.elements();
                    }

                    public Object getAttribute(String name) {
                        switch (name) {
                            case "url": {
                                return someUrl;
                            }
                            case "jsessionid": {
                                return "jsessionid";
                            }
                        }
                        return super.getAttribute(name);
                    }

                    public String getParameter(String name) {
                        switch (name) {
                            case "url": {
                                return someUrl;
                            }
                            case "jsessionid": {
                                return "jsessionid";
                            }
                        }
                        return super.getParameter(name);
                    }
                };
                req.setAttribute("url", (Object)someUrl);
                try {
                    super.doGet((HttpServletRequest)wrapper, resp);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        } else {
            try {
                resp.sendError(403, "Only a system administrator can access this resource");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DatabaseMetaData getConnectionMetaData() {
        try {
            return this.connection.getMetaData();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getConnectionUrl() {
        try {
            return this.connection.getMetaData().getURL();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void inject(Class clazz, Object obj, String fieldName, Object newValue) {
        Field fs = null;
        try {
            fs = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        fs.setAccessible(true);
        try {
            fs.set(obj, newValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

