package org.h2.server.web;

import java.sql.Connection;
import java.sql.SQLException;

import com.atlassian.database.console.HackedWebServlet;

public class HackedWebServer extends WebServer
{
    WebSession session;
    HackedWebServlet servlet;

    public HackedWebServer(String[] args, HackedWebServlet servlet)
    {
        //without this response won't be written back
        super.setAllowChunked(false);
        super.setAllowOthers(true);

        super.init(args);

        //if there was ever h2 installation then servlet will try to init defaults again
        super.setAllowChunked(false);
        super.setAllowOthers(true);
        
        this.servlet = servlet;

        //create single session which will be maintained through plugin lifecycle
        this.session = this.createNewSession("local");
    }

    @Override
    Connection getConnection(String driver, String databaseUrl, String user, String password) throws SQLException
    {
        return servlet.getConnection();
    }

    @Override
    public WebSession getSession(String s)
    {
        //#getSession is called as part of #createNewSession, it's just hackaround to ignore first time invocation
        if (this.session == null)
        {
            this.session = super.getSession(s);
        }

        // if setter is used then BNF will be reset and autocomplete won't work
        HackedWebServlet.inject(this.session.getClass(), this.session, "conn", servlet.getConnection());
        HackedWebServlet.inject(this.session.getClass(), this.session, "meta", servlet.getConnectionMetaData());

        return this.session;
    }
}