/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.struts.multipart;

import com.atlassian.struts.multipart.AtlassianMultiPartRequest;
import com.atlassian.struts.multipart.FileUploadException;
import com.atlassian.struts.multipart.UploadedFile;
import com.atlassian.struts.multipart.impl.AtlassianMultiPartRequestWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.struts2.dispatcher.LocalizedMessage;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MultiPartUtil {
    private MultiPartUtil() {
    }

    public static @Nullable AtlassianMultiPartRequest unwrapMultiPartRequest(HttpServletRequest request) {
        if (request instanceof AtlassianMultiPartRequest) {
            return (AtlassianMultiPartRequest)request;
        }
        if (request instanceof MultiPartRequestWrapper) {
            return new AtlassianMultiPartRequestWrapper((MultiPartRequestWrapper)request);
        }
        if (request instanceof HttpServletRequestWrapper && ((HttpServletRequestWrapper)request).getRequest() instanceof HttpServletRequest) {
            return MultiPartUtil.unwrapMultiPartRequest((HttpServletRequest)((HttpServletRequestWrapper)request).getRequest());
        }
        return null;
    }

    public static UploadedFile getUploadedFile(HttpServletRequest request, String fileParameterName) throws FileUploadException {
        return MultiPartUtil.getUploadedFiles(request).stream().filter(uploadedFile -> uploadedFile.getParameterName().equals(fileParameterName)).findFirst().orElse(null);
    }

    public static List<UploadedFile> getUploadedFiles(HttpServletRequest request) throws FileUploadException {
        return MultiPartUtil.getUploadedFiles(request, true);
    }

    public static List<UploadedFile> getUploadedFiles(HttpServletRequest request, boolean ignoreMissingFiles) throws FileUploadException {
        AtlassianMultiPartRequest multiWrapper = MultiPartUtil.unwrapMultiPartRequest(request);
        if (multiWrapper == null) {
            return Collections.emptyList();
        }
        MultiPartUtil.throwIfMultiPartRequestHasErrors(multiWrapper);
        ArrayList<UploadedFile> uploadedFiles = new ArrayList<UploadedFile>();
        Enumeration<String> e = multiWrapper.getFileParameterNames();
        ArrayList<LocalizedMessage> errors = new ArrayList<LocalizedMessage>();
        while (e.hasMoreElements()) {
            String inputValue = e.nextElement();
            org.apache.struts2.dispatcher.multipart.UploadedFile[] files = multiWrapper.getFiles(inputValue);
            for (int i = 0; i < files.length; ++i) {
                org.apache.struts2.dispatcher.multipart.UploadedFile file = files[i];
                if (file == null) {
                    errors.add(new LocalizedMessage(MultiPartUtil.class, "struts.messages.error.uploading", "Error uploading " + multiWrapper.getFileSystemNames(inputValue)[i], new Object[]{multiWrapper.getFileSystemNames(inputValue)[i]}));
                    continue;
                }
                uploadedFiles.add(new UploadedFile(inputValue, new File(file.getAbsolutePath()), multiWrapper.getFileNames(inputValue)[i], multiWrapper.getContentTypes(inputValue)[i]));
            }
        }
        if (!ignoreMissingFiles && !errors.isEmpty()) {
            throw new FileUploadException(errors.toArray(new LocalizedMessage[0]));
        }
        return Collections.unmodifiableList(uploadedFiles);
    }

    public static void throwIfMultiPartRequestHasErrors(HttpServletRequest request) throws FileUploadException {
        AtlassianMultiPartRequest multiWrapper = MultiPartUtil.unwrapMultiPartRequest(request);
        if (multiWrapper == null || !multiWrapper.hasErrors()) {
            return;
        }
        throw new FileUploadException(multiWrapper.getErrors().toArray(new LocalizedMessage[0]));
    }
}

