/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.introspect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ClassIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.MapperConfig;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.introspect.MethodFilter;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicClassIntrospector
extends ClassIntrospector<BasicBeanDescription> {
    public static final BasicClassIntrospector instance = new BasicClassIntrospector();

    @Override
    public BasicBeanDescription forSerialization(SerializationConfig cfg, Class<?> c, ClassIntrospector.MixInResolver r) {
        AnnotationIntrospector ai = cfg.getAnnotationIntrospector();
        AnnotatedClass ac = AnnotatedClass.construct(c, ai, r);
        ac.resolveMemberMethods(this.getSerializationMethodFilter(cfg), false);
        ac.resolveCreators(true);
        ac.resolveFields(false);
        return new BasicBeanDescription(TypeFactory.type(c), ac, ai);
    }

    @Override
    public BasicBeanDescription forDeserialization(DeserializationConfig cfg, JavaType type, ClassIntrospector.MixInResolver r) {
        AnnotationIntrospector ai = cfg.getAnnotationIntrospector();
        AnnotatedClass ac = AnnotatedClass.construct(type.getRawClass(), ai, r);
        ac.resolveMemberMethods(this.getDeserializationMethodFilter(cfg), true);
        ac.resolveCreators(true);
        ac.resolveFields(true);
        return new BasicBeanDescription(type, ac, ai);
    }

    @Override
    public BasicBeanDescription forCreation(DeserializationConfig cfg, Class<?> c, ClassIntrospector.MixInResolver r) {
        AnnotationIntrospector ai = cfg.getAnnotationIntrospector();
        AnnotatedClass ac = AnnotatedClass.construct(c, ai, r);
        ac.resolveCreators(true);
        return new BasicBeanDescription(TypeFactory.type(c), ac, ai);
    }

    @Override
    public BasicBeanDescription forClassAnnotations(MapperConfig cfg, Class<?> c, ClassIntrospector.MixInResolver r) {
        AnnotationIntrospector ai = cfg.getAnnotationIntrospector();
        AnnotatedClass ac = AnnotatedClass.construct(c, ai, r);
        return new BasicBeanDescription(TypeFactory.type(c), ac, ai);
    }

    protected MethodFilter getSerializationMethodFilter(SerializationConfig cfg) {
        return GetterMethodFilter.instance;
    }

    protected MethodFilter getDeserializationMethodFilter(DeserializationConfig cfg) {
        if (cfg.isEnabled(DeserializationConfig.Feature.USE_GETTERS_AS_SETTERS)) {
            return SetterAndGetterMethodFilter.instance;
        }
        return SetterMethodFilter.instance;
    }

    public static final class SetterAndGetterMethodFilter
    extends SetterMethodFilter {
        public static final SetterAndGetterMethodFilter instance = new SetterAndGetterMethodFilter();

        public boolean includeMethod(Method m) {
            if (super.includeMethod(m)) {
                return true;
            }
            if (!ClassUtil.hasGetterSignature(m)) {
                return false;
            }
            Class<?> rt = m.getReturnType();
            return Collection.class.isAssignableFrom(rt) || Map.class.isAssignableFrom(rt);
        }
    }

    public static class SetterMethodFilter
    implements MethodFilter {
        public static final SetterMethodFilter instance = new SetterMethodFilter();

        public boolean includeMethod(Method m) {
            if (Modifier.isStatic(m.getModifiers())) {
                return false;
            }
            int pcount = m.getParameterTypes().length;
            switch (pcount) {
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
            }
            return false;
        }
    }

    public static class GetterMethodFilter
    implements MethodFilter {
        public static final GetterMethodFilter instance = new GetterMethodFilter();

        private GetterMethodFilter() {
        }

        public boolean includeMethod(Method m) {
            return ClassUtil.hasGetterSignature(m);
        }
    }
}

