/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.testing;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.streams.api.UserProfile;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.uri.Uris;
import com.atlassian.streams.spi.UserProfileAccessor;
import com.google.common.base.Objects;
import java.net.URI;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

public abstract class AbstractUserProfileAccessorTestSuite {
    @Mock
    private ApplicationProperties applicationProperties;
    protected UserProfileAccessor userProfileAccessor;

    protected abstract String getProfilePathTemplate();

    protected abstract String getProfilePicturePathTemplate();

    protected ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    @Before
    public void prepareApplicationProperties() {
        Mockito.when((Object)this.applicationProperties.getBaseUrl()).thenReturn((Object)"http://localhost/streams");
    }

    @Test
    public void assertThatUserProfileWithUsernameAsFullnameIsReturnedWhenUserDoesNotExist() {
        URI baseUri = URI.create("http://localhost/streams");
        MatcherAssert.assertThat((Object)this.userProfileAccessor.getUserProfile(baseUri, "idonotexist"), (Matcher)Matchers.is(AbstractUserProfileAccessorTestSuite.sameUsername(new UserProfile.Builder("idonotexist").build())));
    }

    @Test
    public void assertThatWhenUserExistsUserProfileIsReturned() {
        URI baseUri = URI.create("http://localhost/streams");
        MatcherAssert.assertThat((Object)this.userProfileAccessor.getUserProfile(baseUri, "user"), (Matcher)Matchers.is(AbstractUserProfileAccessorTestSuite.equalTo(new UserProfile.Builder("user").fullName("User").email(Option.some((Object)"u@c.com")).profilePageUri(Option.option((Object)this.getProfileUri("user"))).profilePictureUri(Option.option((Object)this.getProfilePictureUri(this.getProfilePicParameter("user")))).build())));
    }

    @Test
    public void assertThatUsernameIsUriEncodedInProfileUri() {
        URI baseUri = URI.create("http://localhost/streams");
        MatcherAssert.assertThat((Object)this.userProfileAccessor.getUserProfile(baseUri, "user 2").getProfilePageUri(), (Matcher)Matchers.is(AbstractUserProfileAccessorTestSuite.equalTo(Option.some((Object)this.getProfileUri("user 2")))));
    }

    @Test
    public void assertThatUsernameIsUriEncodedInProfilePictureUri() {
        URI baseUri = URI.create("http://localhost/streams");
        MatcherAssert.assertThat((Object)this.userProfileAccessor.getUserProfile(baseUri, "user 2").getProfilePictureUri(), (Matcher)Matchers.is(AbstractUserProfileAccessorTestSuite.equalTo(Option.option((Object)this.getProfilePictureUri(this.getProfilePicParameter("user 2"))))));
    }

    @Test
    public void assertThatFullNameIsNotEncoded() {
        URI baseUri = URI.create("http://localhost/streams");
        MatcherAssert.assertThat((Object)this.userProfileAccessor.getUserProfile(baseUri, "user3").getFullName(), (Matcher)Matchers.is(AbstractUserProfileAccessorTestSuite.equalTo("User <3&'>")));
    }

    private URI getProfileUri(String username) {
        return URI.create(this.applicationProperties.getBaseUrl() + this.getProfilePathTemplate().replace("{username}", Uris.encode((String)username)));
    }

    private URI getProfilePictureUri(String parameter) {
        if (this.getProfilePicturePathTemplate() != null) {
            return URI.create(this.getProfilePicApplicationBaseUrl() + this.getProfilePicturePathTemplate().replace("{profilePictureParameter}", Uris.encode((String)parameter)));
        }
        return null;
    }

    protected String getProfilePicParameter(String username) {
        return username;
    }

    protected String getProfilePicApplicationBaseUrl() {
        return this.applicationProperties.getBaseUrl();
    }

    private static Matcher<? super UserProfile> sameUsername(final UserProfile expected) {
        return new TypeSafeDiagnosingMatcher<UserProfile>(){

            protected boolean matchesSafely(UserProfile actual, Description mismatchDescription) {
                if (actual == null) {
                    mismatchDescription.appendValue(null);
                    return false;
                }
                if (!Objects.equal((Object)actual.getUsername(), (Object)expected.getUsername())) {
                    mismatchDescription.appendText("userName=").appendValue((Object)actual.getUsername());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("username=").appendValue((Object)expected.getUsername());
            }
        };
    }

    private static Matcher<? super UserProfile> equalTo(final UserProfile expected) {
        return new TypeSafeDiagnosingMatcher<UserProfile>(){

            protected boolean matchesSafely(UserProfile actual, Description mismatchDescription) {
                boolean matches = true;
                if (expected == actual) {
                    return matches;
                }
                if (actual == null) {
                    mismatchDescription.appendValue(null);
                    return false;
                }
                if (!Objects.equal((Object)actual.getUsername(), (Object)expected.getUsername())) {
                    mismatchDescription.appendText("username=").appendValue((Object)actual.getUsername());
                    matches = false;
                }
                if (!Objects.equal((Object)actual.getFullName(), (Object)expected.getFullName())) {
                    if (!matches) {
                        mismatchDescription.appendText(", ");
                    }
                    mismatchDescription.appendText("fullName=").appendValue((Object)actual.getFullName());
                    matches = false;
                }
                if (!Objects.equal((Object)actual.getEmail(), (Object)expected.getEmail())) {
                    if (!matches) {
                        mismatchDescription.appendText(", ");
                    }
                    mismatchDescription.appendText("email=").appendValue((Object)actual.getEmail());
                    matches = false;
                }
                if (!Objects.equal((Object)actual.getProfilePageUri(), (Object)expected.getProfilePageUri())) {
                    if (!matches) {
                        mismatchDescription.appendText(", ");
                    }
                    mismatchDescription.appendText("profilePageUri=").appendValue((Object)actual.getProfilePageUri());
                    matches = false;
                }
                if (!Objects.equal((Object)actual.getProfilePictureUri(), (Object)expected.getProfilePictureUri())) {
                    if (!matches) {
                        mismatchDescription.appendText(", ");
                    }
                    mismatchDescription.appendText("profilePictureUri=").appendValue((Object)actual.getProfilePictureUri());
                    matches = false;
                }
                return matches;
            }

            public void describeTo(Description description) {
                description.appendText("username=").appendValue((Object)expected.getUsername()).appendText(", fullName=").appendValue((Object)expected.getFullName()).appendText(", email=").appendValue((Object)expected.getEmail()).appendText(", profilePageUri=").appendValue((Object)expected.getProfilePageUri()).appendText(", profilePictureUri=").appendValue((Object)expected.getProfilePictureUri());
            }
        };
    }

    private static <T> Matcher<? super T> equalTo(T expected) {
        return Matchers.equalTo(expected);
    }
}

