/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.testing;

import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.spi.EntityIdentifier;
import com.atlassian.streams.spi.EntityIdentifierMatchers;
import com.atlassian.streams.spi.StandardStreamsFilterOption;
import com.atlassian.streams.testing.AbstractEntityAssociationProviderTest;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public abstract class AbstractEntityAssociationProviderWithIssuesTest
extends AbstractEntityAssociationProviderTest {
    protected static final String ISSUE_ENTITY_KEY = "PROJECT-1";

    protected abstract String getIssueUriPath(String var1);

    protected abstract URI getIssueEntityType();

    protected abstract void setIssueExists(String var1, boolean var2);

    protected abstract void setIssueViewPermission(String var1, boolean var2);

    protected abstract void setIssueEditPermission(String var1, boolean var2);

    protected URI getIssueUri(String key) {
        return URI.create("http://localhost:3990/streams" + this.getIssueUriPath(key));
    }

    protected EntityIdentifier getIssueEntityIdentifier(String key) {
        return new EntityIdentifier(this.getIssueEntityType(), key, this.getIssueUri(key));
    }

    @Test
    public void assertThatIssueUriReturnsIssueAndProjectEntityIdentifiers() {
        this.setIssueExists(ISSUE_ENTITY_KEY, true);
        this.setProjectExists("PROJECT", true);
        this.assertHasIssueAndProjectKeys(this.provider.getEntityIdentifiers(this.getIssueUri(ISSUE_ENTITY_KEY)), ISSUE_ENTITY_KEY, "PROJECT");
    }

    @Test
    public void assertThatIssueUriWithRequestParametersReturnsIssueAndProjectEntityIdentifiers() {
        this.setIssueExists(ISSUE_ENTITY_KEY, true);
        this.setProjectExists("PROJECT", true);
        this.assertHasIssueAndProjectKeys(this.provider.getEntityIdentifiers(URI.create(this.getIssueUri(ISSUE_ENTITY_KEY).toString() + "?req_param=req_value")), ISSUE_ENTITY_KEY, "PROJECT");
    }

    @Test
    public void assertThatIssueUriWithHashReturnsIssueAndProjectEntityIdentifiers() {
        this.setIssueExists(ISSUE_ENTITY_KEY, true);
        this.setProjectExists("PROJECT", true);
        this.assertHasIssueAndProjectKeys(this.provider.getEntityIdentifiers(URI.create(this.getIssueUri(ISSUE_ENTITY_KEY).toString() + "#myhash")), ISSUE_ENTITY_KEY, "PROJECT");
    }

    @Test
    public void assertThatIssueKeyWithoutAbsoluteUriReturnsIssueAndProjectEntityIdentifiers() {
        this.setIssueExists(ISSUE_ENTITY_KEY, true);
        this.setProjectExists("PROJECT", true);
        this.assertHasIssueAndProjectKeys(this.provider.getEntityIdentifiers(URI.create(ISSUE_ENTITY_KEY)), ISSUE_ENTITY_KEY, "PROJECT");
    }

    @Test
    public void assertThatUnknownIssueUriReturnsNoIdentifier() {
        this.setIssueExists(ISSUE_ENTITY_KEY, false);
        this.setProjectExists("PROJECT", false);
        MatcherAssert.assertThat((Object)this.provider.getEntityIdentifiers(this.getIssueUri(ISSUE_ENTITY_KEY)), EntityIdentifierMatchers.hasNoEntityIdentifiers());
    }

    @Test
    public void assertThatUnknownIssueKeyReturnsNoIdentifier() {
        this.setIssueExists(ISSUE_ENTITY_KEY, false);
        this.setProjectExists("PROJECT", false);
        MatcherAssert.assertThat((Object)this.provider.getEntityIdentifiers(URI.create(ISSUE_ENTITY_KEY)), EntityIdentifierMatchers.hasNoEntityIdentifiers());
    }

    @Test
    public void assertThatIssueIdentifierReturnsIssueUri() {
        MatcherAssert.assertThat((Object)this.provider.getEntityURI(this.getIssueEntityIdentifier(ISSUE_ENTITY_KEY)), (Matcher)Matchers.equalTo((Object)Option.some((Object)this.getIssueUri(ISSUE_ENTITY_KEY))));
    }

    @Test
    public void assertThatIssueIdentifierReturnsIssueFilterKey() {
        MatcherAssert.assertThat((Object)this.provider.getFilterKey(this.getIssueEntityIdentifier(ISSUE_ENTITY_KEY)), (Matcher)Matchers.equalTo((Object)Option.some((Object)StandardStreamsFilterOption.ISSUE_KEY.getKey())));
    }

    private void assertHasIssueAndProjectKeys(Iterable<EntityIdentifier> identifiers, String issueKey, String projectKey) {
        MatcherAssert.assertThat(identifiers, (Matcher)Matchers.contains((Object[])new EntityIdentifier[]{this.getIssueEntityIdentifier(issueKey), this.getProjectEntityIdentifier(projectKey)}));
    }
}

