/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.spi;

import com.atlassian.streams.spi.EntityIdentifier;
import java.net.URI;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class EntityIdentifierMatchers {
    public static Matcher<Iterable<EntityIdentifier>> hasEntityIdentifiers(Matcher<EntityIdentifier> ... matchers) {
        return Matchers.hasItems(matchers);
    }

    public static Matcher<Iterable<? extends EntityIdentifier>> hasNoEntityIdentifiers() {
        return Matchers.emptyIterable();
    }

    public static Matcher<EntityIdentifier> withType(Matcher<? super URI> matcher) {
        return new WithType(matcher);
    }

    public static Matcher<EntityIdentifier> withUri(Matcher<? super URI> matcher) {
        return new WithUri(matcher);
    }

    public static Matcher<EntityIdentifier> withValue(Matcher<? super String> matcher) {
        return new WithValue(matcher);
    }

    private static final class WithValue
    extends TypeSafeDiagnosingMatcher<EntityIdentifier> {
        private final Matcher<? super String> matcher;

        public WithValue(Matcher<? super String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(EntityIdentifier identifier, Description mismatchDescription) {
            if (!this.matcher.matches((Object)identifier.getValue())) {
                mismatchDescription.appendText("value ");
                this.matcher.describeMismatch((Object)identifier.getValue(), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("value ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WithUri
    extends TypeSafeDiagnosingMatcher<EntityIdentifier> {
        private final Matcher<? super URI> matcher;

        public WithUri(Matcher<? super URI> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(EntityIdentifier identifier, Description mismatchDescription) {
            if (!this.matcher.matches((Object)identifier.getUri())) {
                mismatchDescription.appendText("uri ");
                this.matcher.describeMismatch((Object)identifier.getUri(), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("uri ").appendDescriptionOf(this.matcher);
        }
    }

    private static final class WithType
    extends TypeSafeDiagnosingMatcher<EntityIdentifier> {
        private final Matcher<? super URI> matcher;

        public WithType(Matcher<? super URI> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(EntityIdentifier identifier, Description mismatchDescription) {
            if (!this.matcher.matches((Object)identifier.getType())) {
                mismatchDescription.appendText("type ");
                this.matcher.describeMismatch((Object)identifier.getType(), mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("type ").appendDescriptionOf(this.matcher);
        }
    }
}

