/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.internal;

import com.atlassian.failurecache.failures.ExponentialBackOffFailureCache;
import com.atlassian.failurecache.failures.FailureCache;
import com.atlassian.failurecache.util.date.Clock;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.streams.api.common.Either;
import com.atlassian.streams.internal.ActivityProvider;
import com.atlassian.streams.internal.ActivityProviderCallable;
import com.atlassian.streams.internal.Sys;
import com.atlassian.streams.spi.CancellableTask;
import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.atlassian.util.concurrent.ThreadFactories;
import com.atlassian.util.concurrent.Timeout;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public final class StreamsCompletionService
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(StreamsCompletionService.class);
    private static final boolean IGNORE_FAILURE_CACHE = Sys.inDevMode() && Boolean.getBoolean("com.atlassian.streams.aggregator.ignore.failure.cache");
    private final ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory;
    private final PluginEventManager pluginEventManager;
    private final ResettableLazyReference<Execution> async = new ResettableLazyReference<Execution>(){

        protected Execution create() throws Exception {
            return new Execution(StreamsCompletionService.this.threadLocalDelegateExecutorFactory, StreamsCompletionService.this.failureCache);
        }
    };
    private final FailureCache<ActivityProvider> failureCache;

    StreamsCompletionService(ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory, PluginEventManager pluginEventManager, Clock clock) {
        this.threadLocalDelegateExecutorFactory = (ThreadLocalDelegateExecutorFactory)Preconditions.checkNotNull((Object)threadLocalDelegateExecutorFactory, (Object)"threadLocalDelegateExecutorFactory");
        this.pluginEventManager = (PluginEventManager)Preconditions.checkNotNull((Object)pluginEventManager, (Object)"pluginEventManager");
        this.failureCache = new ExponentialBackOffFailureCache(clock);
    }

    public Predicate<ActivityProvider> reachable() {
        return Predicates.not((Predicate)new Predicate<ActivityProvider>(){

            public boolean apply(ActivityProvider activityProvider) {
                return !IGNORE_FAILURE_CACHE && StreamsCompletionService.this.failureCache.isFailing((Object)activityProvider);
            }
        });
    }

    public <T> Iterable<Either<ActivityProvider.Error, T>> execute(Iterable<? extends ActivityProviderCallable<Either<ActivityProvider.Error, T>>> callables) {
        if (Iterables.isEmpty(callables)) {
            return ImmutableSet.of();
        }
        Iterable results = ((Execution)this.async.get()).invokeAll(callables);
        this.registerFailures(results);
        return results;
    }

    public <T> Iterable<Either<ActivityProvider.Error, T>> execute(Iterable<? extends ActivityProviderCallable<Either<ActivityProvider.Error, T>>> callables, long time, TimeUnit unit) {
        if (Iterables.isEmpty(callables)) {
            return ImmutableSet.of();
        }
        Iterable results = ((Execution)this.async.get()).invokeAll(callables, time, unit);
        this.registerFailures(results);
        return results;
    }

    private <T> void registerFailures(Iterable<Either<ActivityProvider.Error, T>> results) {
        for (ActivityProvider.Error error : Either.getLefts(results)) {
            if (!error.getActivityProvider().isDefined() || !this.isNotUserSpecificError(error)) continue;
            logger.warn("Registering failure for stream provider {} due to error {}", (Object)((ActivityProvider)error.getActivityProvider().get()).getName(), (Object)error);
            this.failureCache.registerFailure(error.getActivityProvider().get());
        }
    }

    private boolean isNotUserSpecificError(ActivityProvider.Error errors) {
        ActivityProvider.Error.Type type = errors.getType();
        return !type.equals((Object)ActivityProvider.Error.Type.CREDENTIALS_REQUIRED) && !type.equals((Object)ActivityProvider.Error.Type.UNAUTHORIZED);
    }

    private void resetCompletionService() {
        if (this.async.isInitialized()) {
            ((Execution)this.async.get()).close();
        }
        this.async.reset();
    }

    public synchronized void afterPropertiesSet() {
        this.resetCompletionService();
        this.pluginEventManager.register((Object)this);
    }

    public synchronized void destroy() {
        this.resetCompletionService();
        this.pluginEventManager.unregister((Object)this);
    }

    @PluginEventListener
    public void onShutdown(PluginFrameworkShutdownEvent event) {
        this.resetCompletionService();
    }

    private static final class Completer {
        private final Executor executor;
        private final ExecutorCompletionServiceFactory completionServiceFactory;

        Completer(Executor executor, ExecutorCompletionServiceFactory completionServiceFactory) {
            this.executor = (Executor)Assertions.notNull((String)"executor", (Object)executor);
            this.completionServiceFactory = (ExecutorCompletionServiceFactory)Assertions.notNull((String)"completionServiceFactory", (Object)completionServiceFactory);
        }

        public <T> Iterable<Either<ActivityProvider.Error, T>> invokeAll(Iterable<? extends ActivityProviderCallable<Either<ActivityProvider.Error, T>>> callables, long time, TimeUnit unit) {
            return this.invokeAll(callables, Timeout.getNanosTimeout((long)time, (TimeUnit)unit));
        }

        public <T> Iterable<Either<ActivityProvider.Error, T>> invokeAll(Iterable<? extends ActivityProviderCallable<Either<ActivityProvider.Error, T>>> jobs) {
            return this.invokeAll(jobs, null);
        }

        /*
         * Exception decompiling
         */
        private <T> Iterable<Either<ActivityProvider.Error, T>> invokeAll(Iterable<? extends ActivityProviderCallable<Either<ActivityProvider.Error, T>>> callables, @Nullable Timeout nanosTimeout) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
             *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        static <T> Function<Supplier<? extends T>, T> fromSupplier() {
            return new Function<Supplier<? extends T>, T>(){

                public T apply(Supplier<? extends T> supplier) {
                    return supplier.get();
                }
            };
        }

        private static class CompletionFunction<T>
        implements Function<ActivityProviderCallable<Either<ActivityProvider.Error, T>>, Supplier<Either<ActivityProvider.Error, T>>> {
            private final CompletionService<Either<ActivityProvider.Error, T>> completionService;
            private Timeout nanosTimeout;

            CompletionFunction(CompletionService<Either<ActivityProvider.Error, T>> completionService, @Nullable Timeout nanosTimeout) {
                this.completionService = completionService;
                this.nanosTimeout = nanosTimeout;
            }

            public Supplier<Either<ActivityProvider.Error, T>> apply(final ActivityProviderCallable<Either<ActivityProvider.Error, T>> task) {
                final Future<Either<ActivityProvider.Error, T>> future = this.completionService.submit(task);
                return Suppliers.memoize((Supplier)new Supplier<Either<ActivityProvider.Error, T>>(){

                    public Either<ActivityProvider.Error, T> get() {
                        try {
                            if (CompletionFunction.this.nanosTimeout == null) {
                                return (Either)future.get();
                            }
                            return (Either)future.get(CompletionFunction.this.nanosTimeout.getTime(), CompletionFunction.this.nanosTimeout.getUnit());
                        }
                        catch (InterruptedException e) {
                            logger.debug("Handling a non-timeout exception", (Throwable)e);
                            return Either.left((Object)ActivityProvider.Error.timeout(task.getActivityProvider()));
                        }
                        catch (ExecutionException e) {
                            logger.debug("Handling a non-timeout exception", (Throwable)e);
                            return Either.left((Object)ActivityProvider.Error.other(task.getActivityProvider()));
                        }
                        catch (TimeoutException e) {
                            logger.debug("Handling a timeout", (Object)e.getMessage());
                            future.cancel(true);
                            return Either.left((Object)ActivityProvider.Error.timeout(task.getActivityProvider()));
                        }
                    }
                });
            }
        }

        public static interface ExecutorCompletionServiceFactory {
            public <T> Function<Executor, CompletionService<Either<ActivityProvider.Error, T>>> create();
        }
    }

    static class Execution {
        private static final int MAX_POOL_SIZE = Integer.getInteger("streams.completion.service.pool.max", 32);
        private final ExecutorService executorService;
        private final Completer completer;
        private final FailureCache failureCache;

        Execution(ThreadLocalDelegateExecutorFactory factory, FailureCache failureCache) {
            this.failureCache = failureCache;
            this.executorService = factory.createExecutorService(this.newLimitedCachedThreadPool(ThreadFactories.namedThreadFactory((String)"StreamsCompletionService:"), MAX_POOL_SIZE));
            this.completer = new Completer(this.executorService, Execution.cancellingCompletionServiceFactory(failureCache));
        }

        private ExecutorService newLimitedCachedThreadPool(ThreadFactory threadFactory, int limit) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(limit, limit, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            return threadPoolExecutor;
        }

        <T> Iterable<Either<ActivityProvider.Error, T>> invokeAll(Iterable<? extends ActivityProviderCallable<Either<ActivityProvider.Error, T>>> jobs) {
            return this.completer.invokeAll(jobs);
        }

        <T> Iterable<Either<ActivityProvider.Error, T>> invokeAll(Iterable<? extends ActivityProviderCallable<Either<ActivityProvider.Error, T>>> jobs, long time, TimeUnit unit) {
            return this.completer.invokeAll(jobs, time, unit);
        }

        void close() {
            this.executorService.shutdownNow();
        }

        private static Completer.ExecutorCompletionServiceFactory cancellingCompletionServiceFactory(FailureCache failureCache) {
            return new CancellingCompletionServiceFactory(failureCache);
        }

        private static final class CancellingCompletionService<T>
        implements CompletionService<T> {
            private final CompletionService<T> delegate;
            private final FailureCache failureCache;
            private final ConcurrentHashMap<Future<T>, Future<T>> originalFutureToWrappedFuture;

            CancellingCompletionService(Executor executor, FailureCache failureCache) {
                this.delegate = new ExecutorCompletionService<T>(executor);
                this.failureCache = failureCache;
                this.originalFutureToWrappedFuture = new ConcurrentHashMap();
            }

            @Override
            public Future<T> poll() {
                return this.wrappedFuture(this.delegate.poll());
            }

            @Override
            public Future<T> poll(long timeout, TimeUnit unit) throws InterruptedException {
                return this.wrappedFuture(this.delegate.poll(timeout, unit));
            }

            @Override
            public Future<T> submit(final Callable<T> task) {
                logger.debug("Submitting task stream provider {}", (Object)((ActivityProviderCallable)task).getActivityProvider().getName());
                final Future<T> f = this.delegate.submit(task);
                Future wrappedFuture = new Future<T>(){
                    volatile boolean cancelled = false;

                    @Override
                    public boolean cancel(boolean mayInterrupt) {
                        if (task instanceof CancellableTask) {
                            CancellableTask.Result r = ((CancellableTask)task).cancel();
                            switch (r) {
                                case CANCELLED: {
                                    this.cancelled = true;
                                    break;
                                }
                                case CANNOT_CANCEL: {
                                    this.cancelled = false;
                                    break;
                                }
                                case INTERRUPT: {
                                    this.cancelled = f.cancel(mayInterrupt);
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException("Unknown result type '" + r + "' returned from CancellableTask.cancel");
                                }
                            }
                        } else {
                            this.cancelled = f.cancel(mayInterrupt);
                        }
                        logger.warn("Registering failure for stream provider {} due to cancellation (timeout)", (Object)((ActivityProviderCallable)task).getActivityProvider().getName());
                        CancellingCompletionService.this.failureCache.registerFailure((Object)((ActivityProviderCallable)task).getActivityProvider());
                        CancellingCompletionService.this.originalFutureToWrappedFuture.remove(f);
                        return this.cancelled;
                    }

                    @Override
                    public T get() throws InterruptedException, ExecutionException {
                        logger.debug("Attempting get from stream provider {}", (Object)((ActivityProviderCallable)task).getActivityProvider().getName());
                        Object value = f.get();
                        CancellingCompletionService.this.failureCache.registerSuccess((Object)((ActivityProviderCallable)task).getActivityProvider());
                        return value;
                    }

                    @Override
                    public T get(long t, TimeUnit u) throws InterruptedException, ExecutionException, TimeoutException {
                        logger.debug("Attempting get from stream provider {} with timeout {} {}", new Object[]{((ActivityProviderCallable)task).getActivityProvider().getName(), String.valueOf(t), u.toString()});
                        Object value = f.get(t, u);
                        CancellingCompletionService.this.failureCache.registerSuccess((Object)((ActivityProviderCallable)task).getActivityProvider());
                        return value;
                    }

                    @Override
                    public boolean isCancelled() {
                        return this.cancelled;
                    }

                    @Override
                    public boolean isDone() {
                        return this.cancelled || f.isDone();
                    }
                };
                this.originalFutureToWrappedFuture.put(f, wrappedFuture);
                return wrappedFuture;
            }

            @Override
            public Future<T> submit(Runnable task, T result) {
                throw new UnsupportedOperationException("Not implemented");
            }

            @Override
            public Future<T> take() throws InterruptedException {
                return this.wrappedFuture(this.delegate.take());
            }

            private Future<T> wrappedFuture(Future<T> future) {
                if (future == null) {
                    return future;
                }
                return this.originalFutureToWrappedFuture.remove(future);
            }
        }

        private static class CancellingCompletionServiceFactory
        implements Completer.ExecutorCompletionServiceFactory {
            private final FailureCache failureCache;

            private CancellingCompletionServiceFactory(FailureCache failureCache) {
                this.failureCache = failureCache;
            }

            @Override
            public <T> Function<Executor, CompletionService<Either<ActivityProvider.Error, T>>> create() {
                return new Function<Executor, CompletionService<Either<ActivityProvider.Error, T>>>(){

                    public CompletionService<Either<ActivityProvider.Error, T>> apply(Executor e) {
                        return new CancellingCompletionService(e, CancellingCompletionServiceFactory.this.failureCache);
                    }
                };
            }
        }
    }
}

