/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.internal;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.streams.api.common.Either;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.api.common.uri.Uri;
import com.atlassian.streams.internal.ActivityProvider;
import com.atlassian.streams.internal.ActivityProviderCancellableTask;
import com.atlassian.streams.internal.ActivityProviders;
import com.atlassian.streams.internal.ActivityRequestImpl;
import com.atlassian.streams.internal.HttpParameters;
import com.atlassian.streams.internal.NoMatchingRemoteKeysException;
import com.atlassian.streams.internal.StreamsCompletionService;
import com.atlassian.streams.internal.Sys;
import com.atlassian.streams.internal.feed.FeedAggregator;
import com.atlassian.streams.internal.feed.FeedModel;
import com.atlassian.streams.spi.CancellableTask;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FeedBuilder {
    private final Logger log = LoggerFactory.getLogger(FeedBuilder.class);
    private final ActivityProviders activityProviders;
    private final FeedAggregator aggregator;
    private final StreamsCompletionService completionService;
    private final ApplicationProperties applicationProperties;

    public FeedBuilder(ActivityProviders activityProviders, FeedAggregator aggregator, StreamsCompletionService completionService, ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        this.activityProviders = (ActivityProviders)Preconditions.checkNotNull((Object)activityProviders, (Object)"activityProviders");
        this.aggregator = (FeedAggregator)Preconditions.checkNotNull((Object)aggregator, (Object)"aggregator");
        this.completionService = (StreamsCompletionService)Preconditions.checkNotNull((Object)completionService, (Object)"completionService");
    }

    public FeedModel getFeed(Uri self, String contextPath, HttpParameters parameters, String requestLanguages) {
        Iterable<ActivityProvider> providers = this.activityProviders.get((Iterable<Predicate<ActivityProvider>>)ImmutableSet.of(parameters.module(), parameters.fetchLocalOnly(), parameters.isSelectedProvider()));
        ImmutableSet banned = ImmutableSet.copyOf((Iterable)Iterables.filter(providers, (Predicate)Predicates.not(this.completionService.reachable())));
        Iterable notBannedProviders = Iterables.filter(providers, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)banned)));
        Iterable callables = Iterables.transform((Iterable)notBannedProviders, this.toFeedCallable((Pair<Uri, HttpParameters>)Pair.pair((Object)self, (Object)parameters), parameters.calculateContextUrl(this.applicationProperties, contextPath), requestLanguages));
        Iterable<Object> results = Sys.inDevMode() && !parameters.isTimeoutTest() ? this.completionService.execute(callables) : this.completionService.execute(callables, 10000L, TimeUnit.MILLISECONDS);
        return this.aggregator.aggregate(Iterables.concat(results, (Iterable)Iterables.transform((Iterable)banned, this.toLeftBanned())), self, parameters.parseMaxResults(10), parameters.getTitle());
    }

    private final Function<ActivityProvider, ActivityProviderCancellableTask<Either<ActivityProvider.Error, FeedModel>>> toFeedCallable(Pair<Uri, HttpParameters> feedParameters, URI baseUri, String requestLanguages) {
        return new ToFeedCallable(feedParameters, baseUri, requestLanguages);
    }

    private Function<ActivityProvider, Either<ActivityProvider.Error, FeedModel>> toLeftBanned() {
        return new Function<ActivityProvider, Either<ActivityProvider.Error, FeedModel>>(){

            public Either<ActivityProvider.Error, FeedModel> apply(@Nullable ActivityProvider activityProvider) {
                return Either.left((Object)ActivityProvider.Error.banned(activityProvider));
            }
        };
    }

    private final class ToFeedCallable
    implements Function<ActivityProvider, ActivityProviderCancellableTask<Either<ActivityProvider.Error, FeedModel>>> {
        private final Pair<Uri, HttpParameters> feedParameters;
        private final String requestLanguages;
        private final URI contextUri;

        private ToFeedCallable(Pair<Uri, HttpParameters> feedParameters, URI contextUri, String requestLanguages) {
            this.feedParameters = feedParameters;
            this.contextUri = contextUri;
            this.requestLanguages = requestLanguages;
        }

        public ActivityProviderCancellableTask<Either<ActivityProvider.Error, FeedModel>> apply(final ActivityProvider provider) {
            ActivityRequestImpl.Builder builder = ActivityRequestImpl.builder((Uri)this.feedParameters.first()).contextUri(this.contextUri);
            if (((HttpParameters)this.feedParameters.second()).useAcceptLanguage()) {
                // empty if block
            }
            ActivityRequestImpl request = builder.build((HttpParameters)this.feedParameters.second(), provider);
            final CancellableTask<Either<ActivityProvider.Error, FeedModel>> task = provider.getActivityFeed(request);
            return new ActivityProviderCancellableTask<Either<ActivityProvider.Error, FeedModel>>(){

                @Override
                public Either<ActivityProvider.Error, FeedModel> call() throws Exception {
                    try {
                        return (Either)task.call();
                    }
                    catch (NoMatchingRemoteKeysException nmrke) {
                        FeedBuilder.this.log.info("No keys from " + provider.getName() + " matched " + Joiner.on((String)",").join(nmrke.getKeys()), (Throwable)nmrke);
                        return Either.left((Object)ActivityProvider.Error.other());
                    }
                    catch (Exception e) {
                        FeedBuilder.this.log.error("Error fetching feed", (Throwable)e);
                        return Either.left((Object)ActivityProvider.Error.other());
                    }
                }

                public CancellableTask.Result cancel() {
                    return task.cancel();
                }

                @Override
                public ActivityProvider getActivityProvider() {
                    return provider;
                }
            };
        }
    }
}

