define('widget/sidebar', [
    'chaperone',
    'jquery',
    'util/client-storage',
    'util/events',
    'exports'
], function(
    Chaperone,
    $,
    clientStorage,
    events,
    exports
    ) {

    'use strict';

    var IS_EXPANDED_KEY = 'sidebar_expanded';

    var sidebarSelector = '.aui-sidebar';
    var sidebar;
    function initSidebar() {
        sidebar = AJS.sidebar(sidebarSelector);

        sidebar.on('collapse-end', function() {
            clientStorage.setItem(IS_EXPANDED_KEY, false); // TODO: this should only be saved on user-initiated collapses, not any collapse)
            events.trigger('stash.feature.sidebar.collapseEnd');

        });
        sidebar.on('expand-end', function() {
            clientStorage.setItem(IS_EXPANDED_KEY, true);
            events.trigger('stash.feature.sidebar.expandEnd');
        });

        /**
         * TODO: Remove this when AUI-2484 is resolved
         * The original implementation left out `e.target` as a fallback for Firefox.
         *
         * Note that we're using mousemove as the main event to watch here as it is the last event fired when a MouseEvent
         * occurs on an element. We monitor, but ignore, mouseleave event to avoid getting stuck in hover mode.
         * Since mousemove is called frequently we cache the element we're moving on to avoid unnecessary events
         * @aui-override
         */
        var currentEl = null;
        sidebar.$el.find('.aui-sidebar-body').on('mousemove mouseleave', function(e) {
            // don't do anything if we have e.srcElement = handled by AUI already
            if (typeof e.srcElement === 'undefined' && e.target !== currentEl) {
                var hoveringBlankArea = (e.type === 'mousemove') &&
                    !$(e.target).parentsUntil(sidebar.$el).filter('.aui-page-header, .aui-navgroup').length;

                sidebar.$el.toggleClass('aui-is-hover', hoveringBlankArea);
                currentEl = e.target;
            }
        });

        initFeatureDiscovery();
    }

    function initFeatureDiscovery() {
        var isExpanded = clientStorage.getItem(IS_EXPANDED_KEY);
        sidebar.on('expand', function() { isExpanded = true; });
        sidebar.on('collapse', function() { isExpanded = false; });

        Chaperone.registerFeature('sidebar', [{
            id : 'sidebar-discovery',
            selector : '.aui-sidebar[aria-expanded=false] .aui-page-header, .aui-sidebar[aria-expanded=true] .aui-sidebar-group:first-child',
            title : AJS.I18n.getText('stash.web.global.sidebar.feature.discovery.title'),
            content : stash.widget.sidebar.discoveryContent(),
            moreInfo : {
                href: 'http://go.atlassian.com/stashsidebar'
            },
            gravity: 'w',
            width: 350,
            offsetX: function() { return isExpanded ? -10 : 10; },
            once: true
        }]);

        sidebar.on('expand', Chaperone.checkFeatureAlignment);
        sidebar.on('collapse', Chaperone.checkFeatureAlignment);
        sidebar.on('expand-end', Chaperone.checkFeatureAlignment);
        sidebar.on('collapse-end', Chaperone.checkFeatureAlignment);

    }

    function preloadSidebar() {
        var state = clientStorage.getItem(IS_EXPANDED_KEY);
        $(document.body).toggleClass("aui-sidebar-collapsed", !state);
        $(sidebarSelector).attr("aria-expanded", state);
    }

    exports.preload = preloadSidebar;
    exports.onReady = initSidebar;
});
