define("widget/paged-table",["aui","jquery","underscore","util/ajax","widget/error-dialog","widget/paged-scrollable"],function(B,F,C,E,A,G){function D(H){H=F.extend(true,{},D.defaults,H);G.call(this,H.scrollPane,H);this.$table=F(H.target);if(H.filterable){this.$filter=H.filter?F(H.filter):this.$table.prev(".paged-table-filter").find(".paged-table-filter-input");this._currentFilterText=F.trim(this.$filter.val());var I=C.debounce(C.bind(this._onFilterChanged,this),H.filterDebounce);this.$filter.on("keyup.paged-table-filter",function(J){if(J.which===F.ui.keyCode.ESCAPE){F(this).blur()}else{I(J)}}).on("paste.paged-table-filter",I)}this.$spinner=F("<div class='spinner'/>").hide().insertAfter(this.$table);this.spinnerShowing=false;this.processedDomData=(this.$table.attr("data-lastpage")==null)}D.defaults={ajaxDataType:"json",spinnerSize:"large",filterable:false,filterDebounce:350,rowSelector:"> tbody > tr",focusOptions:{escToCancel:false,focusedClass:"focused",rowSelector:"> tbody > tr",wrapAround:false}};F.extend(D.prototype,G.prototype);D.prototype.init=function(){return G.prototype.init.apply(this,arguments).done(C.bind(function(){if(this.shortcutsInitialised){this.focusInitialRow()}},this))};D.prototype.getFilterText=function(){return this._currentFilterText};D.prototype._onFilterChanged=function(){var H=F.trim(this.$filter.val());if(this._currentFilterText!==H){this._currentFilterText=H;this.update()}};D.prototype.requestData=function(J,H){if(!this.processedDomData){return F.Deferred().resolve(this.createDataFromJQuery(J,H,this.$table))}var I=this;I.spinnerShowing=true;I.$spinner.show().spin(I.options.spinnerSize);return I.performAjax(J,H).always(function(){I._hideSpinnerTimeout=setTimeout(function(){I.spinnerShowing&&I.$spinner.spinStop().hide();I.spinnerShowing=false},0)})};D.prototype.performAjax=function(J,H){var I=this;return E.ajax({url:I.buildUrl(J,H,I.getFilterText()),dataType:I.options.ajaxDataType,statusCode:I.options.statusCode})};D.prototype.cancelRequest=function(){G.prototype.cancelRequest.call(this);if(this._hideSpinnerTimeout){clearTimeout(this._hideSpinnerTimeout)}};D.prototype.reset=function(){G.prototype.reset.call(this);if(this.processedDomData){this.$table.find(this.options.rowSelector).remove().end().next(".paged-table-message").remove().end()}this.$table.addClass("no-rows")};D.prototype.update=function(H){this.reset();return this.init(H)};D.prototype.createDataFromJQuery=function(N,H,K){var J=K.find(this.options.rowSelector);var I=K.attr("data-lastpage")==="true";var M=K.attr("data-nextpagestart");var L={start:Number(K.attr("data-start")),size:Number(K.attr("data-size")),values:J,isLastPage:I};if(M!=null){L.nextPageStart=Number(M)}return L};D.prototype.attachNewContent=function(I,H){if(I.size){if(this.processedDomData){if(I&&I.errors){this.handleErrors(I.errors);return }this.handleNewRows(I,H)}if(I.start>0&&I.isLastPage){this.handleLastPage()}this.$table.removeClass("no-rows")}else{if(I.isLastPage){this.handleNoData()}}this.updateTimestamp();this.processedDomData=true};D.prototype.updateTimestamp=function(){this.$table.attr("data-last-updated",new Date().getTime())};D.prototype.focusInitialRow=function(){this.$table.find(this.options.focusOptions.rowSelector).first().addClass(this.options.focusOptions.focusedClass)};D.prototype.initShortcuts=function(){this.shortcutsInitialised=true;this.focusInitialRow();return{destroy:C.bind(this.resetShortcuts,this)}};D.prototype.resetShortcuts=function(){this.shortcutsInitialised=false};D.prototype._new$Message=function(H){return F('<div class="paged-table-message"/>').addClass(this.options.tableMessageClass).html(H||"")};D.prototype.handleLastPage=function(){this.$table.after(this._new$Message(this.options.allFetchedMessageHtml))};D.prototype.handleNoData=function(){var I=this.getFilterText();var H=I&&I.length?this.options.noneMatchingMessageHtml:this.options.noneFoundMessageHtml;this.$table.addClass("no-rows").after(this._new$Message(H))};D.prototype.handleErrors=function(H){new A({panelContent:"<p>"+B.escapeHtml(H[0].message)+"</p>"}).show()};D.prototype.buildUrl=function(J,H,I){throw new Error("buildUrl is abstract and must be implemented.")};D.prototype.handleNewRows=function(I,H){throw new Error("handleNewRows is abstract and must be implemented.")};return D});