define('widget/approve', [
    'jquery',
    'util/ajax',
    'util/deprecation',
    'util/events',
    'model/page-state',
    'widget/button-trigger'
], function(
    $,
    ajax,
    deprecate,
    events,
    pageState,
    ButtonTrigger
) {

    'use strict';

    function Approve(selectorTrigger, url) {
        this._opts = {
            url: url,
            triggerHandler: this.buttonClicked
        };

        ButtonTrigger.call(this, selectorTrigger, this._opts);

        var self = this;

        var handler = function (data) {
            if (pageState.getCurrentUser() && data.user.name === pageState.getCurrentUser().getName() &&
                data.pullRequestId === pageState.getPullRequest().getId()) {

                self.setTriggerActive(data.approved);

                var newTitle = data.approved ?
                    AJS.I18n.getText('stash.web.pullrequest.toolbar.approved.tooltip') :
                    AJS.I18n.getText('stash.web.pullrequest.toolbar.approve.tooltip');
                self._$trigger.attr('title', newTitle + self._$trigger.data('kbShortcutAppended'));

            }
        };

        // optimistic event listening (assume it works, then revert if necessary)
        events.on('stash.widget.approve-button.adding', handler);
        events.on('stash.widget.approve-button.removing', handler);
        events.on('stash.widget.approve-button.add.failed', handler);
        events.on('stash.widget.approve-button.remove.failed', handler);
    }
    $.extend(Approve.prototype, ButtonTrigger.prototype);

    Approve.prototype.buttonClicked = function (isOn, event) {
        var self = this;

        function fireEvent(eventName, approved) {
            events.trigger(eventName, self, {
                approved : approved,
                pullRequestId: pageState.getPullRequest().getId(),
                user: deprecate.jsonAsBrace(pageState.getCurrentUser(), '3.2', '4.0')
            });
        }

        fireEvent(isOn ? 'stash.widget.approve-button.adding' : 'stash.widget.approve-button.removing', isOn);

        ajax.rest({
            url: self._opts.url,
            type: isOn ? 'POST' : 'DELETE',
            statusCode: {
                '401' : function(xhr, textStatus, errorThrown, errors, dominantError) {
                    return $.extend({}, dominantError, {
                        title: AJS.I18n.getText('stash.web.pullrequest.approve.error.401.title'),
                        message: AJS.I18n.getText('stash.web.pullrequest.approve.error.401.message'),
                        fallbackUrl: false,
                        shouldReload: true
                    });
                },
                '409' : function(xhr, textStatus, errorThrown, errors, dominantError) {
                    return $.extend({}, dominantError, {
                        title: AJS.I18n.getText('stash.web.pullrequest.approve.error.409.title'),
                        fallbackUrl: false,
                        shouldReload: true
                    });
                }
            }
        }).done(function() {
            fireEvent(isOn ? 'stash.widget.approve-button.added' : 'stash.widget.approve-button.removed', isOn);
        }).fail(function () {
            fireEvent(isOn ? 'stash.widget.approve-button.add.failed' : 'stash.widget.approve-button.remove.failed', !isOn);
        });
    };

    return Approve;
});
