define('util/navbuilder', [
    'jquery',
    'stash/api/util/navbuilder',
    'util/deprecation'
], function (
    $,
    navbuilder,
    deprecate
) {

    'use strict';

    var movedExports = $.extend({}, navbuilder, {
        // Returns a PathAndQuery which is otherwise private. Should always have returned a builder, which is public.
        newBuilder : function() {
            return navbuilder.newBuilder.apply(this, arguments)._path();
        }
    });

    var removedExports = {
        //Append trailing slash to url if there isn't one already.
        appendSlashToUrl : function appendSlashToUrl(url) {
            if (typeof url !== 'string') {
                return '/';
            } else {
                return url + ((url.charAt(url.length - 1) !== '/') ? '/' : '');
            }
        },
        // only used by Soy function. Making it private
        avatarUrl : navbuilder._avatarUrl
    };

    deprecate.obj(movedExports, 'util/navbuilder.', 'stash/api/util/navbuilder.', '3.0', '4.0');
    deprecate.obj(removedExports, 'util/navbuilder.', null, '3.0', '4.0');

    return $.extend(removedExports, movedExports);
});
