define('page/users/profile', [
    'jquery',
    'util/flash-notifications',
    'feature/repository/repository-table',
    'exports'
], function (
    $,
    flashNotifications,
    RepositoryTable,
    exports
) {
    'use strict';

    exports.onReady = function(repositoryTableSelector, personalProjectKey, isOwnProfile, userDisplayName, isPersonalRepositoryEnabled) {
        // Attach flash notifications. Can be result of deleted repositories
        flashNotifications.attachNotifications(repositoryTableSelector, 'before');

        var repositoryTableParams = {
            projectKey: personalProjectKey,
            showPublicStatus: true,
            noneFoundMessageHtml: isOwnProfile ?
                stash.users.profile.noRepositoriesSelf({projectKey: personalProjectKey}) :
                stash.users.profile.noRepositories({userDisplayName: userDisplayName}),
            bufferPixels: $('#footer').height()
        };

        if (!isPersonalRepositoryEnabled) {
            repositoryTableParams.noneFoundMessageHtml = stash.users.profile.personalRepositoryDisabled();
        }

        new RepositoryTable(repositoryTableSelector, repositoryTableParams).init();
    };
});
