define('page/repository/noDefaultBranch', [
    'stash/api/util/navbuilder',
    'util/events',
    'exports'
], function(
    navbuilder,
    events,
    exports
) {
    exports.onReady = function() {
        events.on('stash.feature.repository.revisionReferenceSelector.revisionRefChanged', function(revisionReference) {
            var uri = navbuilder.parse(location.href);
            uri.addQueryParam("at", revisionReference.getId());
            location.href = uri.toString();
        });
    };
});