define('page/repository-fork', [
    'jquery',
    'model/page-state',
    'model/repository',
    'feature/project/project-selector',
    'feature/repository/cloneUrlGen',
    'exports'
], function (
    $,
    pageState,
    Repository,
    ProjectSelector,
    cloneUrlGen,
    exports
) {
    'use strict';

    function initRepositoryPageState(repositoryJson) {
        var repo = new Repository(repositoryJson);
        pageState.setRepository(repo);
        pageState.setProject(repo.getProject());
    }

    function initProjectSelector(projectSelectorSelector, personalProjectJson) {
        var $projectTrigger = $(projectSelectorSelector);
        var $projectInput = $projectTrigger.next('input');
        var $preloadData = personalProjectJson ? [personalProjectJson] : null;
        return new ProjectSelector($projectTrigger, {
            field: $projectInput,
            preloadData: ProjectSelector.constructDataPageFromPreloadArray($preloadData)
        });
    }

    exports.onReady = function (repositoryJson, projectSelectorSelector, personalProjectJson) {
        initRepositoryPageState(repositoryJson);
        var projectSelector = initProjectSelector(projectSelectorSelector, personalProjectJson);

        cloneUrlGen.bindUrlGeneration("#name", "#name + .description .clone-url > span", function () {
            return projectSelector.getSelectedItem();
        });
    };
});
