define('page/maintenance/backup', [
    'stash/api/util/navbuilder',
    'layout/maintenance',
    'exports'
], function(
    navBuilder,
    maintenance,
    exports
) {

    exports.onReady = function(hasToken) {

        var opts = {
            redirectUrl: hasToken ? navBuilder.admin().build() : navBuilder.allProjects().build(),
            canceledHeader: AJS.I18n.getText('stash.web.backup.canceled.title'),
            cancelingDescription: AJS.I18n.getText('stash.web.backup.canceling.description'),
            cancelDialogTitle: AJS.I18n.getText('stash.web.backup.dialog.title'),
            cancelDialogDescription: AJS.I18n.getText('stash.web.backup.dialog.description'),
            cancelDialogButtonText: AJS.I18n.getText('stash.web.backup.dialog.cancel')
        };

        maintenance.init(opts);
    };
});
