define('page/admin/usersList', [
    'util/flash-notifications',
    'widget/delete-dialog',
    'feature/user/user-table',
    'exports'
], function(
    flashNotifications,
    deleteDialog,
    UserTable,
    exports) {

    exports.onReady = function(tableSelector, deleteLinksSelector) {

        flashNotifications.attachNotifications('.content-body .notifications');

        var userTable = new UserTable({
            target : tableSelector
        });

        userTable.init();

        // confirm dialog to delete groups
        deleteDialog.bind(deleteLinksSelector,
            AJS.I18n.getText('stash.web.user.delete'),
            AJS.I18n.getText('stash.web.user.delete.success'),
            AJS.I18n.getText('stash.web.user.delete.fail'),
            function(displayName) {
                flashNotifications.addNotification(AJS.I18n.getText('stash.web.user.delete.success', displayName));
                location.reload();
            }
        );
    };
});