define('page/admin/groupsList', [
    'util/flash-notifications',
    'widget/delete-dialog',
    'feature/user/group-table',
    'exports'
], function(
    flashNotifications,
    deleteDialog,
    GroupTable,
    exports) {

    exports.onReady = function(tableSelector, deleteLinksSelector) {

        flashNotifications.attachNotifications('.content-body .notifications');

        var groupTable = new GroupTable({
            target : tableSelector
        });

        groupTable.init();

        // confirm dialog to delete groups
        deleteDialog.bind(deleteLinksSelector,
            AJS.I18n.getText('stash.web.group.delete'),
            AJS.I18n.getText('stash.web.group.delete.success'),
            AJS.I18n.getText('stash.web.group.delete.fail'),
            function(group) {
                flashNotifications.addNotification(AJS.I18n.getText('stash.web.group.delete.success', group));
                location.reload();
            });
    };
});
