define('layout/setup/tracking', [
    'jquery',
    'exports'
], function(
    $,
    exports
) {
    "use strict";

    var setupIframe = function(isDevMode, serverId, pageId, version) {
        var iframeHost = isDevMode ? "https://qa-wac.internal.atlassian.com" : "https://www.atlassian.com";
        var iframeContextPath = "/pingback";
        var iframeQueryStringParams = $.param({
            product: 'stash',
            sid: serverId,
            pg: pageId,
            v: version
        });
        // Setup progress iframe tracker
        $("<iframe>").attr("id", "setup-progress-iframe").css("display", "none").appendTo("body").attr("src", iframeHost + iframeContextPath + "?" + iframeQueryStringParams);
    };

    /**
     * Tracks progress through the setup wizard in order to measure drop off
     */
    exports.track = function (maybePageId) {
        var $content  = $("#content");
        // ServerId is used to uniquely identify an installation
        var serverId  = $content.attr('data-server-id');
        var isDevMode = $content.attr('data-dev-mode-enabled') === "true";
        var version   = $.trim($("#product-version").text());
        var pageId    = maybePageId ? maybePageId : window.location.pathname.replace(/\//g, "_");
        setupIframe(isDevMode, serverId, pageId, version);
    };
});
