define('feature/pull-request/can-merge', [
    'stash/api/util/navbuilder',
    'util/ajax',
    'util/events',
    'model/page-state'
], function(
    navBuilder,
    ajax,
    events,
    pageState
) {

    function canMerge(pullRequest){
         pullRequest = pullRequest || pageState.getPullRequest();

         return ajax.rest({
             url: navBuilder.rest()
                 .currentRepo()
                 .pullRequest(pullRequest.getId())
                 .merge()
                 .build(),
             type: 'GET'
         }).done(function(data) {
            events.trigger(data.canMerge ? 'stash.pull-request.can.merge' : 'stash.pull-request.cant.merge', null, pullRequest, data.conflicted, data.vetoes);
         });
     }

    return canMerge;
});
