define('feature/compare/compare-commits', [
    'jquery',
    'underscore',
    'stash/api/util/navbuilder',
    'util/bacon',
    'feature/commits/commits-table'
], function(
    $,
    _,
    nav,
    bacon,
    CommitsTable
) {

    "use strict";

    /**
     * Get a builder to build the URL used to fetch the list of changesets.
     *
     * @param {SourceTargetSelector} sourceTargetSelector the UI component used to pick the source branch and repository
     * @returns {stash/api/util/navbuilder.Builder} a builder to build the URL used to fetch the list of changesets
     * @private
     */
    function getCommitsUrlBuilder(sourceTargetSelector) {
        var sourceRepo = sourceTargetSelector.getSourceRepository();
        return nav.project(sourceRepo.getProject()).repo(sourceRepo).commits().withParams({
            until : sourceTargetSelector.getSourceBranch().getLatestChangeset(),
            since :  sourceTargetSelector.getTargetBranch().getLatestChangeset(),
            secondaryRepositoryId : sourceTargetSelector.getTargetRepository().getId()
        });
    }

    return function onReady(commitsTableWebSections) {
        var keyboardRegisterEvent = bacon.events('stash.widget.keyboard-shortcuts.register-contexts');
        return function renderCompareCommits(sourceTargetSelector, $el) {
            var $table = $(stash.feature.compare.commits({
                repository : sourceTargetSelector.getSourceRepository().toJSON(),
                commitsTableWebSections : commitsTableWebSections
            }));

            $el.append($table);

            var commitsTable = new CommitsTable(_.partial(getCommitsUrlBuilder, sourceTargetSelector), {
                target: $table,
                webSections : commitsTableWebSections,
                allFetchedMessageHtml: AJS.I18n.getText('stash.web.repository.compare.allcommitsfetched'),
                noneFoundMessageHtml: AJS.I18n.getText('stash.web.repository.compare.nocommitsfetched')
            });

            commitsTable.init({ suspended : true }).done(function() {
                commitsTable.resume();
            });

            var keyboardDestroy = keyboardRegisterEvent.onValue(function(keyboardShortcuts) {
                keyboardShortcuts.enableContext('commits');
            });
            commitsTable.bindKeyboardShortcuts();

            return function() {
                keyboardDestroy();
                commitsTable.destroy();
            };
        };
    };
});
