<%@ page import="com.atlassian.stash.Product" %>
<%@ page import="com.atlassian.stash.util.Progress" %>
<%@ page import="com.atlassian.stash.internal.lifecycle.StartupUtils" %>
<%@ page import="com.atlassian.stash.internal.lifecycle.StartupManager" %>
<!DOCTYPE html>
<html>
<%
    ServletContext servletContext = pageContext.getServletContext();
    StartupManager startupManager = StartupUtils.getStartupManager(servletContext);
    Progress progress = startupManager.getProgress();
%>
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=EDGE">
    <title><%= Product.FULL_NAME %> - Starting</title>
    <style>
        * {
            box-sizing: border-box;
        }

        body {
            background-color: #F0F0F0;
            color: #666666;
            text-align: center;
            margin-top: 90px;
            font-family: sans-serif;
            font-size: 18px;
            line-height: 1.3;
        }

        h1 {
            color: #333333;
            font-weight:normal;
            font-size: 32px;
            margin: 0;
        }

        .stash-logo {
            width: 60px;
            height: 60px;
            margin: 20px auto 30px;
        }

        .header {
            border-bottom: 2px solid #e9e9e9;
            padding: 0 0 30px;
            margin: 0 0 30px;
        }

        .message {
            font-size: 20px;
            overflow: hidden;
            text-overflow: ellipsis;
            width: 100%;
            white-space: nowrap;
            text-align: left;
        }

        .section {
            width: 600px;
            margin: 0 auto;
            background-color: #FFFFFF;
            border: 1px solid #ccc;
            border-radius: 4px;
            padding: 30px 40px;
            text-align: center;
        }

        .progress-bar {
            width: 100%;
            background-color: #e9e9e9;
            height: 6px;
            border-radius: 3px;
            overflow: hidden;
            margin: 0 0 20px;
            position: relative;
        }

        .progress-indicator {
            display: block;
            background-color: #3b7fc4;
            height: 100%;
            color: #fff;
            transition:width 0.2s ease-in-out;
        }

        .progress-indicator.unknown {
            width: 100%;
            -webkit-animation: progressSlide 1s infinite linear;
            animation: progressSlide 1s infinite linear;
            background: 0 0;
            background-color: transparent;
            background-size: 20px 5px;
            background-image: linear-gradient(90deg, #ccc 50%, transparent 50%, transparent 100%);
            border-radius: 3px;
            display: block;
            height: 5px;
            -webkit-transform: skewX(45deg);
            transform: skewX(45deg);
            position: absolute;
            width: 100%
        }
        @-webkit-keyframes progressSlide {
            0% { background-position: 20px }
            100% { background-position: 0 }
        }

        @keyframes progressSlide {
            0% { background-position: 20px }
            100% { background-position: 0 }
        }

        footer {
            width: 600px;
            margin: 30px auto;
        }

        footer .logo {
            display: block;
            height: 24px; /* match image height */
            margin: 30px auto;
            text-align: left;
            text-indent: -9999em;
            width: 114px; /* match image width */
            background: url(data:image/png;base64,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) center bottom no-repeat;
            background-size: 114px 24px;
        }

        footer .logo:hover,
        footer .logo:active,
        footer .logo:focus {
            background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAHIAAAAYCAYAAAAmsqlBAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyRpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoTWFjaW50b3NoKSIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpDNTgwNjJGOUI2ODQxMUUyOUVGQ0Q4Qzg0RUU4NDAzMyIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDpDNTgwNjJGQUI2ODQxMUUyOUVGQ0Q4Qzg0RUU4NDAzMyI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOkM1ODA2MkY3QjY4NDExRTI5RUZDRDhDODRFRTg0MDMzIiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOkM1ODA2MkY4QjY4NDExRTI5RUZDRDhDODRFRTg0MDMzIi8+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+xRRg6wAAB+xJREFUeNrsWglsVkUQ/lsKUqAgiBQsUCiKoJwilxyeoCBHy2HFIFDQAMGIELAxUUzFAyVEsPEIFNSAFhJSwKIQjggVBFqpBKsCIoJIsELLoXL18pv4vWTY7HuvLf1bNJ3ky/779njz9tudmZ02ZNnuPqcDgcAOYO7EXjv3BipQMHczFNOBacADmD8rUC1BkTBgEpACfIOF34lyObAai55XTvJqoxgIPAkMB0KA14Ds6uUOnoRw8W9C8QowGagBlAixwFeAnNIDwHGQe8ogLQJFc6At0AXoDfQHwtllCzAD43Kql7oSiFTEtEIxCxgLNHAZc55E1yPpphQCXwDzQeCO6iWuAiIVoXKiBgOPAv2AW33myQX2kMB1IPD36qWtYiLj0461R3F01Yjoi4pYOZ2taUbr0LdeAISwYyDupBofiqIzsA9zlART+ageT9WkOQ+llcg8kZlysaoXFXrVRdFdWajd0Ksw2MGOKeuBSBCyAeUmIHVir+hzQgxhFfSPRTEIGApItBoD/GL5yO0ooo3HU/GhG8qh/8NAuqpLgLXiOjggo4CPVL0/441KJTKHJIwibgOeJ1npPJGyu2oJATh1B/B8AH6vUXP8BfxqIbErP8oU8ckbLP3bsq0N0EJUAOEnPfQPu04tXY1gvzDU8mytUX8GRLXm7yK5D/J60U7IQpuYtzeNMekguMgy9wgXPYaAtFqW5+KnXwKeoK+O/I+4rMtG/UJVELmSvs8RCXxSSdizQD6fTwNZF3hH7GrMscDlfbEuz+tzg/xfRNawIdEAViSzMhICV4kEOSAtET8/Vo97AkuABPrBtuiXhn4T8Hu2McVytO11MZMdjGtMfeO0bmRfuZ92s0TLd6PtRpTFwC6fIKg9g64mQASbxCzvwsLut4xpjOJBvlPGFwCSFDkEZGHMn2ru+4GOal7Z3Mck6YF+x/ldXdhWgjFf43kBx3YgInmFEzkBSJ/vlT5invuQo1y0/chnHRlIRVHHdLTluPmU5VzY4erZeOAUSBLiMkHiMJSLjXHyETNc5jTNqmyIhSq6i4WiU6CUkBRnbCRHlqjfXTw2qARp93kQLe2j8a7zrEsi5B36fZu8BSSiXyeUn1mCNUd+YnIk1gh27gUyuPm6eei1nnGAWLqWKkDKQ5us9TgSqCUJbYNspjXAa0MCMzpaZoHAeSRxNXeuIxL2j8TYvFKY1Tx173TkZu5AN5Nfqjsw5bTPWPHx87l4Qsq7HiQ6J1kkxYPEgHJJIS4uLNdHryHAq5Y5JPP2goXEADlIco3yQMgZECanZocxQaJLNiceY7JcdloUzbMjn2PXFXEHvqyex3EXiulbx2hVm+NtwDkGXbK4rVzU38zI+zAXT055U9loyp2MwfunouxrRJVbeXIiaP7kHXvQt46yHiJHZZk4thHv2Vt8iNrMOeXknqJezfndDtljgJlldJHdPcN1EHMUZEoQIsn0xi7dRJkJ6JvuMVWc5a4qks2FjlTmdyZIzqapfQ7l22rcDLTtUxvE+jL0WWwx+9JfTtQkViNoBeoZ3WZj/LcuPvQq94N+c8qy2ui/kO7EnDsVxeOsNkW9nmW4+OFldHs5vF0MZVstXxMGgg4xonQzV+PQ5xOfaeKM07uJH1bsBDiUaHzEXUEM7n4z6uEqCnfkAzmpQEvj+VmjPhl9xD/1YBByLZJbivtwMtZLNtl+rlt+mS/QIOo7nEzJonxpRJolNBNe6apGdPaOZECRc3gui3gDsJ2BlCb9mv7kxYUdDTxCs+dIO0v3LJpqx7z2IGQe0eM96LtUUmyoZzptjIbnECfRJleOJPk2D71CaTrFR+s/SnQMxj3Sln4bz8BnIIMaHXCsQnuEx/Bhhg9K5+VffNwZmgsvM1weSab/SmDk7eB2i7kTXzeBupgi1iEF+k5Xkft+S79mjNbTffRayhTiOEOvmKATCZIGM5SW4EN8RzxPoiMSDCR5TDHC4h/7Btz/THYn75zlPY3i96aW0XetYNAxkpGpaeoeY78DvPbcA8y1kNoP72/ioldLbphKy+xoEkNU+u0hCSAY1LxuSeNFWZQXpz1APTqIxTjsdcfzSeWVRtoZ3yXZqDC8N8Rrw8ndDUgDnmYEelA1R6p+JYAkFeYAnXn/1HKL2wY16hPFUlGvRRWe2TGkvxH+jwVhU7gg8SrzUpOn4EVjvPio2tqsshTF04yF2mjcOedZ9OmMzSF30Po6C+Jzv/ybV50WNJXmZqtLE/wD3Uc+g6BiM3eKvhJZXuFJzLXkVAOG6/HTqxhzxlSEj/QjcrhRT8OJvMTT+gZtvvaFJpEjbdcOfEAekwJ6QXPUpumJenNLpOxkSwpJgE0OGXXxcYss1wyddUn2WQdJj9WgPw/36HeJ98veljYzubIScy710KtCfaSZBtOnyPwryR1MrDvESEQ62Ajfd3q8a60l6FnvEoSEBVz+awGbRLIra4yT4LVYnXzWoJjmM8aHxAAj3Msueh1xrl2l1KtCT+Q+RXYR84XOlSQfxKUqn3CF0WmBSitlK5Oy1eev5J8yCHL6h6L/WWwISWQvYJtslD8C//5jmORJf2a2J8TY9QncAGL+6/JkZzCQmcYFLOTmkiCuIdODbZj4CKOJ3S0xAvTIoAVIZL9OdAfhNK9iTT4E3uf7j/Ba5VzRjqusTTI3aTjN8zbmlafTDRUo87xVcWT+A1umymxd/EeAAQDh8qBwpKQqfgAAAABJRU5ErkJggg==);
            background-size: 114px 24px;
        }
    </style>
</head>
<body>
    <div class="section">
        <div class="header">
            <div class="stash-logo">
                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 18 18">
                    <g transform="scale( 0.98 ) translate(0.2, 0.2)" >
                        <ellipse fill="#205081" cx="9" cy="8.935" rx="2.106" ry="2.121">
                        </ellipse>
                        <g class="rotating" fill="#205081">
                            <path d="M10.088,14.207c0.026,0,0.053-0.003,0.079-0.009c2.428-0.545,4.189-2.76,4.189-5.264               c0-0.55-0.083-1.094-0.244-1.615c-0.034-0.106-0.114-0.193-0.218-0.233c-0.102-0.041-0.218-0.031-0.315,0.024l-0.652,0.38               c-0.144,0.083-0.214,0.255-0.17,0.416c0.092,0.336,0.137,0.682,0.137,1.029c0,1.778-1.193,3.336-2.899,3.79               c-0.162,0.042-0.273,0.189-0.273,0.356v0.758c0,0.112,0.05,0.218,0.137,0.288C9.924,14.178,10.005,14.207,10.088,14.207z"/>
                            <path d="M9,3.537c-1.49,0-2.926,0.636-3.939,1.747C4.985,5.366,4.95,5.479,4.968,5.589               C4.985,5.7,5.051,5.796,5.147,5.852l0.651,0.379c0.056,0.034,0.119,0.051,0.183,0.051c0.095,0,0.189-0.038,0.259-0.109               C6.978,5.425,7.958,5.012,9,5.012c1.043,0,2.024,0.412,2.762,1.16c0.116,0.118,0.297,0.143,0.441,0.06l0.653-0.379               c0.094-0.056,0.16-0.153,0.177-0.263c0.018-0.112-0.018-0.224-0.092-0.306C11.929,4.173,10.492,3.537,9,3.537z"/>
                            <path d="M5.074,7.49L4.422,7.11C4.326,7.054,4.209,7.044,4.106,7.085C4.002,7.126,3.923,7.212,3.89,7.318               C3.727,7.84,3.644,8.384,3.644,8.934c0,2.506,1.761,4.719,4.189,5.264c0.026,0.006,0.053,0.009,0.079,0.009               c0.083,0,0.164-0.028,0.229-0.082c0.087-0.07,0.137-0.175,0.137-0.288V13.08c0-0.167-0.112-0.314-0.273-0.356               C6.3,12.27,5.107,10.711,5.107,8.934c0-0.346,0.046-0.693,0.137-1.029C5.289,7.744,5.218,7.573,5.074,7.49z"/>

                            <animateTransform type="rotate" fill="remove" to="360 9 8.935" begin="0s" dur="10s" calcMode="linear" accumulate="none" from="0 9 8.935" attributeName="transform" additive="replace" restart="whenNotActive" repeatCount="indefinite" end="indefinite"/>
                        </g>
                        <g class="rotating" fill="#205081">
                            <path d="M15.809,14.238l-1.093-0.637c-0.139-0.08-0.313-0.051-0.42,0.068c-1.346,1.525-3.276,2.403-5.296,2.404               c-2.019,0-3.948-0.877-5.296-2.404c-0.105-0.119-0.281-0.147-0.417-0.068L2.19,14.238c-0.086,0.05-0.145,0.135-0.162,0.234               c-0.018,0.097,0.009,0.199,0.073,0.276C3.82,16.814,6.334,18,8.999,18l0,0c2.665-0.001,5.18-1.186,6.9-3.251               c0.063-0.078,0.092-0.178,0.074-0.276C15.956,14.373,15.896,14.288,15.809,14.238z"/>
                            <path d="M10.549,0.005c-0.097-0.017-0.199,0.01-0.273,0.075c-0.078,0.064-0.12,0.159-0.12,0.258v1.271               c0,0.161,0.111,0.299,0.267,0.332c3.281,0.676,5.664,3.619,5.664,6.995c0,0.767-0.124,1.523-0.363,2.253               c-0.051,0.152,0.012,0.319,0.149,0.398l1.097,0.639c0.052,0.03,0.111,0.045,0.169,0.045c0.039,0,0.077-0.007,0.112-0.02               c0.095-0.033,0.169-0.108,0.203-0.202C17.817,11.053,18,10.004,18,8.935C18,4.519,14.868,0.763,10.549,0.005z"/>
                            <path d="M2.277,11.188c-0.241-0.73-0.362-1.487-0.362-2.252c0-3.376,2.381-6.319,5.663-6.995               C7.733,1.907,7.846,1.77,7.846,1.609V0.337c0-0.099-0.043-0.194-0.12-0.258C7.65,0.015,7.549-0.012,7.452,0.006               C3.135,0.763,0.001,4.519,0,8.935c0,1.069,0.185,2.119,0.547,3.114c0.034,0.094,0.108,0.168,0.201,0.202               c0.037,0.013,0.076,0.021,0.113,0.021c0.059,0,0.116-0.017,0.168-0.046l1.096-0.639C2.265,11.507,2.328,11.34,2.277,11.188z"/>

                            <animateTransform type="rotate" fill="remove" to="0 9 8.935" begin="0s" dur="5s" calcMode="linear" accumulate="none" from="360 9 8.935" attributeName="transform" additive="replace" restart="whenNotActive" repeatCount="indefinite" end="indefinite"/>
                        </g>
                    </g>
                </svg>
            </div>
            <h1><%= Product.FULL_NAME %> is starting up</h1>
        </div>

        <p class="message"><span id="message"><%= progress.getMessage()%></span></p>

        <div class="progress-bar"><span id="progress" class="progress-indicator" style="width:<%= progress.getPercentage()%>%"></span></div>
    </div>
    <footer>
        <a href="http://www.atlassian.com" target="_blank" class="logo">Atlassian</a>
    </footer>
    <script>
        (function(){
            var contextPath = '<%= servletContext.getContextPath() %>';
            var messageEl = document.querySelector('#message');
            var progressEl = document.querySelector('#progress');

            function setMessage(msg) {
                messageEl.setAttribute('title', msg);
                messageEl.textContent = msg;
            }

            function setProgress(pct) {
                var val = pct != null ? pct + '%' : null;
                progressEl.style.width = val;
            }

            setTimeout(function poll() {
                var request = new XMLHttpRequest();

                request.onload = function() {
                    var serviceUnavailable = request.status === 503;
                    var json;
                    var message = 'Starting up Stash';
                    var percentage = null;

                    if (this.responseText) {
                        json = JSON.parse(this.responseText);
                        var progress = json.progress;

                        message = progress.message;
                        percentage = progress.percentage;
                    }

                    progressEl.className = 'progress-indicator' + (serviceUnavailable ? ' unknown' : '');
                    setMessage(message);
                    setProgress(percentage);

                    // If the server is starting, or we're waiting to contact the service, continue to poll.
                    if (json && json.state === 'STARTING' || serviceUnavailable) {
                        setTimeout(poll, 500);
                    } else {
                        // When the server's state moves from STARTING to anything else, reload the page.
                        // This is better than checking progress because it handles startup failure
                        location.reload()
                    }
                };

                request.open('get', contextPath + '/system/startup', true);
                request.setRequestHeader('Accept', 'application/json');
                // Set the if-modified-since header to the current time to prevent
                // some browsers from caching the request results.
                request.setRequestHeader("If-Modified-Since", new Date().toUTCString());
                request.send();
            }, 500);
        }());
    </script>
</body>
</html>
