/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util;

import com.atlassian.stash.exception.NoSuchRepositoryException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryMetadataService;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

public class RepositoryControllerSupport
extends ControllerSupport {
    public static final String EMPTY_REPO_VIEW = "stash.page.emptyRepository";
    protected static final String NO_TARGET_REPO_ID_AS_STRING = "-1";
    protected static final int NO_TARGET_REPO_ID = Integer.parseInt("-1");
    protected final InternalProjectService projectService;
    protected final RepositoryService repositoryService;
    protected final RepositoryMetadataService metadataService;
    protected final PermissionService permissionService;

    protected RepositoryControllerSupport(I18nService i18nService, InternalProjectService projectService, RepositoryService repositoryService, RepositoryMetadataService metadataService, PermissionService permissionService) {
        super(i18nService);
        this.metadataService = metadataService;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.permissionService = permissionService;
    }

    @Nonnull
    protected Project getProject(int projectId) {
        Project project = this.projectService.getById(projectId);
        if (project == null) {
            throw this.newNoSuchProjectException(projectId);
        }
        return project;
    }

    @Nonnull
    protected Project getProject(String projectKey) {
        Project project = this.projectService.getByKey(projectKey);
        if (project == null) {
            throw this.newNoSuchProjectException(projectKey);
        }
        return project;
    }

    @Nonnull
    protected Repository getRepository(int repoId) {
        Repository repository = this.repositoryService.getById(repoId);
        if (repository == null) {
            throw this.newNoSuchRepositoryException(repoId);
        }
        return repository;
    }

    @Nonnull
    protected Repository getRepository(String projectKey, String repoSlug) {
        Repository repository = this.repositoryService.getBySlug(projectKey, repoSlug);
        if (repository == null) {
            Project project = this.getProject(projectKey);
            throw this.newNoSuchRepositoryException(project, repoSlug);
        }
        return repository;
    }

    @Nullable
    protected Repository getSecondaryRepository(@Nonnull WebRequest request, @Nonnull Repository primary) {
        String id = request.getParameter("secondaryRepositoryId");
        if (id != null) {
            int repoId = Integer.parseInt(id);
            Repository repository = this.repositoryService.getById(repoId);
            if (repository == null) {
                throw this.newNoSuchRepositoryException(repoId);
            }
            return repository;
        }
        String projectKey = request.getParameter("secondaryProjectKey");
        String repositorySlug = request.getParameter("secondaryRepositorySlug");
        if (projectKey == null) {
            projectKey = primary.getProject().getKey();
        }
        if (repositorySlug == null) {
            repositorySlug = primary.getSlug();
        }
        if (projectKey.equalsIgnoreCase(primary.getProject().getKey()) && repositorySlug.equalsIgnoreCase(primary.getSlug())) {
            return null;
        }
        Repository repository = this.repositoryService.getBySlug(projectKey, repositorySlug);
        if (repository == null) {
            Project project = this.getProject(projectKey);
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.web.nosuchrepo.secondarybyslug", new Object[]{projectKey, repositorySlug});
            throw new NoSuchRepositoryException(message, project);
        }
        return repository;
    }

    @Nonnull
    protected Repository getTargetRepository(@Nonnull Repository repository, int targetRepoId) {
        Repository targetRepository;
        boolean targeted = false;
        Repository toRepository = repository;
        if (targetRepoId != NO_TARGET_REPO_ID && (targetRepository = this.repositoryService.getById(targetRepoId)) != null && repository.getHierarchyId().equals(targetRepository.getHierarchyId())) {
            toRepository = targetRepository;
            targeted = true;
        }
        if (!targeted && repository.isFork() && repository.getProject().getType() == ProjectType.PERSONAL && this.permissionService.hasRepositoryPermission(repository.getOrigin(), Permission.REPO_READ)) {
            toRepository = repository.getOrigin();
        }
        return toRepository;
    }

    protected boolean isEmptyRepository(Repository repository) {
        return repository.getState() != Repository.State.AVAILABLE || this.metadataService.isEmpty(repository);
    }

    protected ModelAndView handleEmptyRepo(Repository repository) {
        return ((StashSoyResponseBuilder)new StashSoyResponseBuilder(EMPTY_REPO_VIEW).putRepository(repository).put("notInitialised", (Object)(repository.getState() != Repository.State.AVAILABLE ? 1 : 0))).build();
    }
}

