/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util;

import com.atlassian.http.mime.ContentDispositionHeaderGuesser;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DownloadHeaderHelper {
    private final ContentDispositionHeaderGuesser contentDispositionGuesser;

    @Autowired
    public DownloadHeaderHelper(ContentDispositionHeaderGuesser contentDispositionGuesser) {
        this.contentDispositionGuesser = contentDispositionGuesser;
    }

    public void setDownloadHeaders(HttpServletResponse response, String fileName, String contentType, String userAgent) {
        String contentDisposition = this.contentDispositionGuesser.guessContentDispositionHeader(fileName, contentType, userAgent);
        if ("attachment".equals(contentDisposition)) {
            response.setHeader("X-Download-Options", "noopen");
        }
        response.setHeader("Content-Disposition", contentDisposition);
        response.setContentType(this.contentDispositionGuesser.guessMIME(fileName, contentType, userAgent));
    }
}

