/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.users;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.plugin.PluginValidationErrors;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.users.AccountPasswordForm;
import com.atlassian.stash.internal.web.users.AccountSettingsForm;
import com.atlassian.stash.ui.PluginFormFragments;
import com.atlassian.stash.ui.PluginFormFragmentsFactory;
import com.atlassian.stash.ui.ValidationErrors;
import com.atlassian.stash.user.DetailedUser;
import com.atlassian.stash.user.IncorrectPasswordAuthenticationException;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserAdminService;
import com.atlassian.stash.user.UserService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/account"})
public class UserAccountController {
    private static final String USER_SETTINGS_FRAGMENT_KEY = "stash.page.user.settings";
    @VisibleForTesting
    static final String SETTINGS_VIEW = "stash.users.account.settings";
    @VisibleForTesting
    static final String PASSWORD_VIEW = "stash.users.account.password";
    private final StashAuthenticationContext authenticationContext;
    private final UserAdminService userAdminService;
    private final UserService userService;
    private final I18nService i18nService;
    private final PluginFormFragmentsFactory formFragmentsFactory;
    private final SpringValidatorAdapter validatorAdapter;

    @Autowired
    public UserAccountController(StashAuthenticationContext authenticationContext, UserAdminService userAdminService, UserService userService, I18nService i18nService, PluginFormFragmentsFactory formFragmentsFactory, SpringValidatorAdapter validatorAdapter) {
        this.authenticationContext = authenticationContext;
        this.userAdminService = userAdminService;
        this.userService = userService;
        this.i18nService = i18nService;
        this.formFragmentsFactory = formFragmentsFactory;
        this.validatorAdapter = validatorAdapter;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView viewSettings() {
        StashUser user = this.getCurrentUserOrThrow();
        DetailedUser detailedUser = this.userAdminService.getUserDetails(user);
        AccountSettingsForm form = new AccountSettingsForm();
        return this.showSettingsPage(SETTINGS_VIEW, detailedUser, false, this.populateFormWithUserDetails(form, detailedUser));
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView updateSettings(AccountSettingsForm form, Errors errors, HttpServletRequest request) {
        StashUser user = this.getCurrentUserOrThrow();
        DetailedUser detailedUser = this.userAdminService.getUserDetails(user);
        if (detailedUser.isMutableDetails()) {
            this.validatorAdapter.validate((Object)form, errors);
        } else {
            form = this.populateFormWithUserDetails(form, detailedUser);
        }
        PluginFormFragments pluginFormFragments = this.getFormFragment(detailedUser);
        PluginValidationErrors pluginErrors = new PluginValidationErrors(errors);
        pluginFormFragments.validate(request.getParameterMap(), (ValidationErrors)pluginErrors);
        if (errors.hasErrors() || pluginErrors.hasFieldErrors()) {
            return this.showSettingsPage(SETTINGS_VIEW, detailedUser, false, form, errors, pluginFormFragments.getErrorHtml(request.getParameterMap(), pluginErrors.getFieldErrors()));
        }
        if (detailedUser.isMutableDetails()) {
            user = this.userService.updateUser(form.getDisplayName(), form.getEmailAddress());
        }
        pluginFormFragments.execute(request.getParameterMap());
        detailedUser = this.userAdminService.getUserDetails(user);
        return this.showSettingsPage(SETTINGS_VIEW, detailedUser, true, form);
    }

    private PluginFormFragments getFormFragment(DetailedUser detailedUser) {
        return this.formFragmentsFactory.forKey(USER_SETTINGS_FRAGMENT_KEY, (Map)ImmutableMap.of((Object)"user", (Object)detailedUser));
    }

    private AccountSettingsForm populateFormWithUserDetails(AccountSettingsForm form, DetailedUser detailedUser) {
        form.setDisplayName(detailedUser.getDisplayName());
        form.setEmailAddress(detailedUser.getEmailAddress());
        return form;
    }

    private ModelAndView showSettingsPage(String viewName, DetailedUser detailedUser, boolean saved, AccountSettingsForm form) {
        return this.showSettingsPage(viewName, detailedUser, saved, form, null, null);
    }

    private ModelAndView showSettingsPage(String viewName, DetailedUser detailedUser, boolean saved, AccountSettingsForm form, Errors errors, String pluginFieldErrors) {
        StashSoyResponseBuilder builder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(viewName).put("user", (Object)detailedUser)).put("accountSettingsForm", (Object)form)).put("mutableDetails", (Object)detailedUser.isMutableDetails())).put("pluginFieldsContent", (Object)(pluginFieldErrors != null ? pluginFieldErrors : this.getFormFragment(detailedUser).getViewHtml()))).put("saved", (Object)saved);
        if (errors != null) {
            builder.putValidationErrors(errors);
        }
        return builder.build();
    }

    @RequestMapping(value={"/password"}, method={RequestMethod.GET})
    public ModelAndView viewPassword() {
        StashUser user = this.getCurrentUserOrThrow();
        return this.showPasswordPage(this.userAdminService.getUserDetails(user), false, null);
    }

    @RequestMapping(value={"/password"}, method={RequestMethod.POST})
    public ModelAndView updatePassword(@Valid AccountPasswordForm form, Errors errors) {
        StashUser user = this.getCurrentUserOrThrow();
        DetailedUser detailedUser = this.userAdminService.getUserDetails(user);
        if (errors.hasErrors()) {
            return this.showPasswordPage(detailedUser, false, errors);
        }
        try {
            this.userService.updatePassword(form.getCurrentPassword(), form.getNewPassword());
        }
        catch (IncorrectPasswordAuthenticationException e) {
            errors.rejectValue("currentPassword", "com.atlassian.stash.validation.password.incorrect.message", this.i18nService.getMessage("stash.web.user.invalidpassword", new Object[0]));
            return this.showPasswordPage(detailedUser, false, errors);
        }
        return this.showPasswordPage(detailedUser, true, errors);
    }

    private StashUser getCurrentUserOrThrow() {
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            throw new AccessDeniedException(this.i18nService.getMessage("stash.web.account.anonymous.error", new Object[0]));
        }
        return currentUser;
    }

    private ModelAndView showPasswordPage(DetailedUser detailedUser, boolean saved, Errors errors) {
        StashSoyResponseBuilder builder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PASSWORD_VIEW).put("user", (Object)detailedUser)).put("mutableDetails", (Object)detailedUser.isMutableDetails())).put("saved", (Object)saved);
        if (errors != null) {
            builder.putValidationErrors(errors);
        }
        return builder.build();
    }
}

