/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.users;

import com.atlassian.soy.springmvc.errors.ErrorUtils;
import com.atlassian.stash.exception.MailException;
import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.users.ResetPasswordForm;
import com.atlassian.stash.mail.MailService;
import com.atlassian.stash.user.DetailedUser;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.SecurityService;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserAdminService;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.Operation;
import java.security.Principal;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PasswordResetController {
    private static final Logger log = LoggerFactory.getLogger(PasswordResetController.class);
    private static final String RESET_PASSWORD_FORM = "stash.users.passwordReset";
    private static final String RESET_PASSWORD_ACKNOWLEDGMENT = "stash.users.passwordResetReceived";
    private static final String CONFIRM_RESET_PASSWORD = "stash.users.passwordResetConfirm";
    private static final String CONFIRM_PASSWORD_SET = "stash.users.passwordSet";
    private final MailService mailService;
    private final SecurityService securityService;
    private final UserAdminService userAdminService;
    private final UserService userService;

    @Autowired
    public PasswordResetController(MailService mailService, SecurityService securityService, UserAdminService userAdminService, UserService userService) {
        this.mailService = mailService;
        this.securityService = securityService;
        this.userAdminService = userAdminService;
        this.userService = userService;
    }

    @RequestMapping(value={"/passwordreset"}, method={RequestMethod.GET}, params={"token"})
    public ModelAndView displayPasswordForm(@RequestParam String token) {
        DetailedUser user = this.userAdminService.findUserByPasswordResetToken(token);
        return new ModelAndView(CONFIRM_RESET_PASSWORD, "form", (Object)new ResetPasswordForm(token, (Principal)user));
    }

    @RequestMapping(value={"/passwordreset"}, method={RequestMethod.GET})
    public ModelAndView displayRequestForm() {
        return this.buildRequestForm(null, false, false, new String[0]);
    }

    @RequestMapping(value={"/passwordreset"}, method={RequestMethod.POST}, params={"token"})
    @IgnoresXsrf
    public ModelAndView resetPassword(@Valid ResetPasswordForm form, Errors errors) {
        if (errors.hasErrors()) {
            return ((StashSoyResponseBuilder)new StashSoyResponseBuilder(CONFIRM_RESET_PASSWORD).put("form", (Object)form)).putValidationErrors(errors).build();
        }
        try {
            this.userAdminService.resetPassword(form.getToken(), form.getPassword());
        }
        catch (Exception e) {
            return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(CONFIRM_RESET_PASSWORD).put("form", (Object)form)).putFormErrors(new String[]{e.getLocalizedMessage()})).build();
        }
        return new ModelAndView(CONFIRM_PASSWORD_SET);
    }

    @RequestMapping(value={"/passwordreset"}, method={RequestMethod.POST})
    @IgnoresXsrf
    public ModelAndView submitRequest(@RequestParam String identifier) {
        StashUser user = this.userService.findUserByNameOrEmail(identifier);
        if (user == null) {
            return this.buildRequestForm(identifier, true, false, new String[0]);
        }
        DetailedUser details = (DetailedUser)this.securityService.withPermission(Permission.ADMIN, "Retrieving mutability details for password reset").call((Operation)new /* Unavailable Anonymous Inner Class!! */);
        if (!details.isMutableDetails()) {
            return this.buildRequestForm(identifier, false, true, new String[0]);
        }
        try {
            this.userAdminService.requestPasswordReset(details.getName());
        }
        catch (MailException e) {
            log.error("A password reset e-mail could not be sent to " + identifier, (Throwable)e);
            return this.buildRequestForm(identifier, false, false, new String[]{e.getLocalizedMessage()});
        }
        catch (Exception e) {
            return this.buildRequestForm(identifier, false, false, new String[]{ErrorUtils.getLocalizedMessageOfRootCause((Throwable)e)});
        }
        return new ModelAndView(RESET_PASSWORD_ACKNOWLEDGMENT);
    }

    private ModelAndView buildRequestForm(String identifier, boolean userNotFound, boolean userNotEditable, String ... systemErrors) {
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(RESET_PASSWORD_FORM).put("canSendEmail", (Object)this.mailService.isHostConfigured())).put("identifier", (Object)identifier)).put("userNotFound", (Object)userNotFound)).put("userNotEditable", (Object)userNotEditable)).putFormErrors(systemErrors)).build();
    }

    static /* synthetic */ UserAdminService access$000(PasswordResetController x0) {
        return x0.userAdminService;
    }
}

