/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.users;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.web.users.AbstractProfileController;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/profile"})
public class CurrentUserProfileController
extends AbstractProfileController {
    @Autowired
    public CurrentUserProfileController(I18nService i18nService, StashAuthenticationContext authenticationContext, InternalProjectService projectService, UserService userService) {
        super(i18nService, authenticationContext, projectService, userService);
    }

    @RequestMapping(value={"/avatar.png"}, method={RequestMethod.GET}, produces={"image/png"})
    public void retrieveAvatar(@RequestParam(defaultValue="256", value="s") int size, HttpServletRequest request, HttpServletResponse response) throws IOException {
        super.retrieveAvatar(this.getCurrentUserOrThrow(), size, request, response);
    }

    @RequestMapping
    public ModelAndView showProfile() {
        return this.showProfile(this.getCurrentUserOrThrow());
    }

    @Nonnull
    private StashUser getCurrentUserOrThrow() {
        StashUser user = this.authenticationContext.getCurrentUser();
        if (user == null) {
            throw new AccessDeniedException(this.i18nService.getMessage("stash.web.profile.avatarforanonymous", new Object[0]));
        }
        return user;
    }
}

