/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.users;

import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.awt.image.BufferedImage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/captcha"})
public class CaptchaController {
    private final ImageCaptchaService imageCaptchaService;

    @Autowired
    public CaptchaController(ImageCaptchaService imageCaptchaService) {
        this.imageCaptchaService = imageCaptchaService;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"image/png"})
    @ResponseBody
    @IgnoresXsrf
    public BufferedImage viewCaptcha(HttpServletRequest request, HttpServletResponse response) {
        BufferedImage image = this.imageCaptchaService.getImageChallengeForID(request.getSession().getId(), request.getLocale());
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        return image;
    }
}

