/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.users;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import com.atlassian.stash.project.PersonalProject;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

public abstract class AbstractProfileController
extends ControllerSupport {
    public static final String OTHERS_PROFILE_VIEW = "stash.users.profile.othersProfile";
    public static final String OWN_PROFILE_VIEW = "stash.users.profile.ownProfile";
    protected final StashAuthenticationContext authenticationContext;
    protected final UserService userService;
    private final InternalProjectService projectService;

    protected AbstractProfileController(I18nService i18nService, StashAuthenticationContext authenticationContext, InternalProjectService projectService, UserService userService) {
        super(i18nService);
        this.authenticationContext = authenticationContext;
        this.projectService = projectService;
        this.userService = userService;
    }

    protected void retrieveAvatar(@Nonnull StashUser user, int size, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws IOException {
        this.streamAvatar(this.userService.getAvatar(user, size), request, response);
    }

    protected ModelAndView showProfile(@Nonnull StashUser user) {
        PersonalProject project = this.projectService.getPersonalProject(user);
        boolean isCurrentUser = user.equals(this.authenticationContext.getCurrentUser());
        StashSoyResponseBuilder builder = ((StashSoyResponseBuilder)new StashSoyResponseBuilder(isCurrentUser ? OWN_PROFILE_VIEW : OTHERS_PROFILE_VIEW).put("user", (Object)user)).putProject((Project)project);
        return builder.build();
    }
}

