/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions.nav;

import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class PreventDomainInferenceFunction
implements SoyServerFunction<String> {
    private static final Pattern DOT_INSIDE_WORD = Pattern.compile("(\\w)\\.(\\w)");

    public String getName() {
        return "prevent_domain_inference";
    }

    public String apply(Object ... args) {
        String text = (String)SoyArgumentUtils.checkType((Object[])args, String.class, (int)0);
        text = StringEscapeUtils.escapeHtml((String)text);
        return DOT_INSIDE_WORD.matcher(text).replaceAll("$1<span>.</span>$2");
    }

    public Set<Integer> validArgSizes() {
        return ImmutableSet.of((Object)1);
    }
}

