/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions.nav;

import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.atlassian.stash.internal.web.soy.functions.nav.JsNavBuilder;
import com.atlassian.stash.internal.web.soy.functions.nav.NavOptionsUtils;
import com.atlassian.stash.nav.NavBuilder;
import com.google.common.base.Preconditions;
import java.util.Set;

public abstract class BaseNavFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    private static final Set<Integer> DEFAULT_VALID_ARG_SIZES = SoyArgumentUtils.argCountFromTo((int)0, (int)1);
    protected final NavBuilder navBuilder;
    private final String name;
    private final Set<Integer> validArgSizes;

    public BaseNavFunction(NavBuilder navBuilder, String name, Set<Integer> validArgSizes) {
        this.navBuilder = navBuilder;
        this.name = name;
        this.validArgSizes = validArgSizes;
    }

    public BaseNavFunction(NavBuilder navBuilder, String name) {
        this(navBuilder, name, DEFAULT_VALID_ARG_SIZES);
    }

    public BaseNavFunction(NavBuilder navBuilder, String name, int requiredArgCount) {
        this(navBuilder, name, SoyArgumentUtils.argCountFromTo((int)requiredArgCount, (int)(requiredArgCount + 1)));
    }

    public BaseNavFunction(NavBuilder navBuilder, String name, int minArgCount, int maxArgCount) {
        this(navBuilder, name, SoyArgumentUtils.argCountFromTo((int)minArgCount, (int)(maxArgCount + 1)));
    }

    protected void ensureValidArgumentCount(Object[] args) {
        Preconditions.checkArgument((boolean)this.validArgSizes().contains(args.length), (Object)("Invalid number of arguments supplied. Expected: " + this.validArgSizes() + ", actual: " + args.length));
    }

    public final String getName() {
        return this.name;
    }

    public final JsExpression generate(JsExpression ... jsExpressions) {
        return this.initJsBuilder(jsExpressions).build();
    }

    public final String apply(Object ... args) {
        NavBuilder.Builder builder = this.initBuilder(args);
        return NavOptionsUtils.withNavOptions((NavOptionsUtils.NavOptionsCallback)new /* Unavailable Anonymous Inner Class!! */, (Object[])args);
    }

    public final Set<Integer> validArgSizes() {
        return this.validArgSizes;
    }

    protected JsNavBuilder initJsBuilder(JsExpression ... jsExpressions) {
        throw new UnsupportedOperationException("This function does not support client-side rendering");
    }

    protected abstract NavBuilder.Builder initBuilder(Object ... var1);
}

