/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions.i18n;

import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.google.common.base.Preconditions;
import java.util.Set;

public class StashI18nFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    private static final Set<Integer> VALID_ARG_SIZES = SoyArgumentUtils.argCountFromTo((int)2, (int)10);
    private final I18nService i18nService;

    public StashI18nFunction(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public String getName() {
        return "stash_i18n";
    }

    public JsExpression generate(JsExpression ... jsExpressions) {
        StringBuilder sb = new StringBuilder();
        sb.append("stash_i18n").append("(");
        boolean isFirst = true;
        for (JsExpression expr : jsExpressions) {
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append(expr.getText());
            isFirst = false;
        }
        return new JsExpression(sb.append(")").toString());
    }

    public String apply(Object ... args) {
        Preconditions.checkArgument((args.length >= 2 ? 1 : 0) != 0, (Object)"Wrong number of arguments (minimum 2)");
        Preconditions.checkArgument((boolean)(args[0] instanceof String), (Object)"The first argument, the key suffix, should be a string");
        Preconditions.checkArgument((args[1] == null || args[1] instanceof String ? 1 : 0) != 0, (Object)"The second argument, the default message, should be a string or null");
        String keySuffix = (String)args[0];
        String defaultMessage = (String)args[1];
        Object[] msgArgs = new Object[args.length - 2];
        System.arraycopy(args, 2, msgArgs, 0, args.length - 2);
        return this.i18nService.getText(keySuffix, defaultMessage, msgArgs);
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

