/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.atlassian.stash.internal.web.soy.functions.SoyArgumentUtils;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPanelFunction
implements SoyServerFunction<List<String>>,
SoyClientFunction {
    private static final Logger LOG = LoggerFactory.getLogger(WebPanelFunction.class);
    private static final Set<Integer> VALID_ARG_SIZES = SoyArgumentUtils.argCountFromTo((int)1, (int)2);
    private final WebInterfaceManager webInterfaceManager;
    private final HttpContext httpContext;
    private final StashAuthenticationContext authenticationContext;

    public WebPanelFunction(WebInterfaceManager webInterfaceManager, HttpContext httpContext, StashAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
        this.httpContext = httpContext;
        this.webInterfaceManager = webInterfaceManager;
    }

    public String getName() {
        return "getWebPanels";
    }

    public JsExpression generate(JsExpression ... args) {
        return new JsExpression("WebFragments.getWebPanels(" + args[0].getText() + (args.length > 1 ? "," + args[1].getText() : "") + ")");
    }

    public List<String> apply(Object ... args) {
        String location = (String)args[0];
        HttpServletRequest request = this.httpContext.getRequest();
        StashUser principal = this.authenticationContext.getCurrentUser();
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        contextBuilder.put((Object)"request", (Object)request);
        if (principal != null) {
            contextBuilder.put((Object)"principal", (Object)principal);
        }
        if (args.length == 2 && args[1] != null) {
            contextBuilder.putAll((Map)args[1]);
        }
        ImmutableMap context = contextBuilder.build();
        List descriptors = this.webInterfaceManager.getDisplayableWebPanelDescriptors(location, (Map)context);
        ArrayList<String> webPanels = new ArrayList<String>(descriptors.size());
        for (WebPanelModuleDescriptor webPanelModuleDescriptor : descriptors) {
            try {
                webPanels.add(((WebPanel)webPanelModuleDescriptor.getModule()).getHtml((Map)context));
            }
            catch (RuntimeException e) {
                LOG.warn(String.format("An error occurred rendering %s. Ignoring", webPanelModuleDescriptor.getCompleteKey()), (Throwable)e);
            }
        }
        if (request != null && request.getParameter("web.panels") != null) {
            webPanels.add("<div class='plugin-point web-panel'><strong>Web Panel</strong>: " + location + "<br />" + "<strong>Context Items</strong>: " + StringUtils.join(context.keySet(), (String)", ") + "</div>");
        }
        return webPanels;
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

