/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy.functions;

import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FormatThrowableFunction
implements SoyServerFunction<String> {
    private static final Set<Integer> VALID_ARG_SIZES = Collections.singleton(1);
    private static final int FRAME_CONTEXT = 3;

    public String getName() {
        return "format_throwable";
    }

    public String apply(Object ... args) {
        Preconditions.checkArgument((boolean)(args[0] instanceof Throwable));
        Throwable throwable = (Throwable)args[0];
        HashSet seen = Sets.newHashSet((Object[])new Throwable[]{throwable});
        StringBuilder formatted = new StringBuilder();
        do {
            seen.add(throwable);
            if (formatted.length() > 0) {
                formatted.append("\n");
            }
            formatted.append(throwable.getMessage());
            StackTraceElement[] stackTrace = throwable.getStackTrace();
            int stackDepth = stackTrace.length;
            for (int i = 0; i < stackDepth && i < 3; ++i) {
                formatted.append("\n\t").append(stackTrace[i]);
            }
            if (stackDepth <= 3) continue;
            formatted.append("\n\t...");
        } while ((throwable = throwable.getCause()) != null && !seen.contains(throwable));
        return formatted.toString();
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

