/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy;

import com.atlassian.soy.springmvc.AbstractSoyResponseBuilder;
import com.atlassian.soy.springmvc.errors.DetailedError;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.MinimalChangeset;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.internal.web.repos.ViewRef;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.repository.Repository;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.View;

public class StashSoyResponseBuilder
extends AbstractSoyResponseBuilder<StashSoyResponseBuilder> {
    public StashSoyResponseBuilder(String viewName) {
        super(viewName);
    }

    public StashSoyResponseBuilder(View view) {
        super(view);
    }

    public StashSoyResponseBuilder putAtRef(ViewRef atRevisionRef) {
        this.model.put("atRevisionRef", atRevisionRef);
        return this.self();
    }

    public StashSoyResponseBuilder putChangeset(MinimalChangeset changeset) {
        Map attributes = this.getDataAttributes();
        attributes.put("changesetId", changeset.getId());
        this.model.put("changeset", changeset);
        return this.self();
    }

    public StashSoyResponseBuilder putDetailedErrors(Iterable<DetailedError> detailedErrors) {
        return detailedErrors == null || Iterables.isEmpty(detailedErrors) ? this.self() : (StashSoyResponseBuilder)super.putDetailedErrors(detailedErrors);
    }

    public StashSoyResponseBuilder putFormErrors(ServiceException e) {
        this.putFormErrors(new String[]{e.getLocalizedMessage()});
        return this.self();
    }

    public StashSoyResponseBuilder putIfNotBlank(String key, String value) {
        return (StashSoyResponseBuilder)this.putIf(StringUtils.isNotBlank((CharSequence)value), key, (Object)value);
    }

    public StashSoyResponseBuilder putIfNotNull(String key, Object value) {
        return (StashSoyResponseBuilder)this.putIf(value != null, key, value);
    }

    public StashSoyResponseBuilder putProject(Project project) {
        Map attributes = this.getDataAttributes();
        attributes.put("projectKey", project.getKey());
        attributes.put("projectName", project.getName());
        this.model.put("project", project);
        return this.self();
    }

    public StashSoyResponseBuilder putPullRequest(PullRequest pullRequest) {
        Map attributes = this.getDataAttributes();
        attributes.put("pullrequestId", String.valueOf(pullRequest.getId()));
        attributes.put("pullrequestVersion", Integer.toString(pullRequest.getVersion()));
        this.model.put("pullRequest", pullRequest);
        return this.self();
    }

    public StashSoyResponseBuilder putRepository(Repository repository) {
        this.putProject(repository.getProject());
        Map attributes = this.getDataAttributes();
        attributes.put("repoSlug", repository.getSlug());
        attributes.put("repoName", repository.getName());
        this.model.put("repository", repository);
        return this.self();
    }

    public StashSoyResponseBuilder putUntilRevision(Changeset untilRevision) {
        this.model.put("untilRevision", untilRevision);
        return this.self();
    }

    public StashSoyResponseBuilder putValidationErrors(Errors errors) {
        return errors == null ? this.self() : (StashSoyResponseBuilder)super.putValidationErrors(errors);
    }

    protected StashSoyResponseBuilder self() {
        return this;
    }
}

