/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.soy;

import com.atlassian.soy.springmvc.InjectedDataFactory;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.locale.InternalLocaleService;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultInjectedDataFactory
implements InjectedDataFactory {
    private final StashAuthenticationContext authenticationContext;
    private final InternalLocaleService localeService;
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public DefaultInjectedDataFactory(ApplicationPropertiesService propertiesService, InternalLocaleService localeService, StashAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
        this.localeService = localeService;
        this.propertiesService = propertiesService;
    }

    public Map<String, Object> createInjectedData(HttpServletRequest request) {
        HashMap injectedData = Maps.newHashMap();
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        injectedData.put("principal", currentUser);
        injectedData.put("timezone", -(this.propertiesService.getDefaultTimeZone().getOffset(System.currentTimeMillis()) / 1000 / 60));
        injectedData.put("instanceName", this.propertiesService.getDisplayName());
        injectedData.put("productName", ApplicationConstants.PRODUCT_NAME);
        injectedData.put("language", this.localeService.getLocale().getLanguage());
        injectedData.put("xsrfTokenName", request.getAttribute("xsrfTokenName"));
        injectedData.put("xsrfTokenValue", request.getAttribute("xsrfTokenValue"));
        return injectedData;
    }
}

